/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.classpath.ClassPathSupportCallbackImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String TAG_MINIMUM_ANT_VERSION = "minimum-ant-version";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private ProjectUpdateListener projectUpdateListener = null;
    private UpdateHelper updateHelper;
    private EditableProperties cachedProperties;

    UpdateProjectImpl(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg) {
        assert (project != null && helper != null && cfg != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
    }

    public void setUpdateHelper(UpdateHelper updateHelper) {
        this.updateHelper = updateHelper;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        if (UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) != null || UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true) != null) {
                            UpdateProjectImpl.this.isCurrent = Boolean.FALSE;
                        } else {
                            UpdateProjectImpl.this.isCurrent = Boolean.TRUE;
                        }
                    }
                    return UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.showUpdateDialog();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties props) throws IOException {
        UpdateProjectImpl refHelper;
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        if (this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) != null) {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
        } else {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
        }
        boolean putProps = false;
        if (props == null) {
            assert (this.updateHelper != null);
            props = this.updateHelper.getProperties("nbproject/project.properties");
            putProps = true;
        }
        if (props != null) {
            props.put("test.src.dir", "test");
            props.put("build.test.classes.dir", "${build.dir}/test/classes");
            props.put("build.test.results.dir", "${build.dir}/test/results");
            props.put("conf.dir", "${source.root}/conf");
            props.put("jspcompilation.classpath", "${jspc.classpath}:${javac.classpath}");
            props.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}:", "${libs.junit_4.classpath}"});
            props.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
            props.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
            props.put("war.ear.name", props.getProperty("war.name"));
            props.put("dist.ear.war", "${dist.dir}/${war.ear.name}");
            if (props.getProperty("lib.dir") == null) {
                props.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
            }
        }
        if (props != null) {
            refHelper = new ReferenceHelper(this.helper, this.cfg, this.helper.getStandardPropertyEvaluator());
            ClassPathSupport cs = new ClassPathSupport(this.helper.getStandardPropertyEvaluator(), (ReferenceHelper)refHelper, this.helper, this.updateHelper, (ClassPathSupport.Callback)new ClassPathSupportCallbackImpl(this.helper));
            Iterator items = cs.itemsIterator(props.get((Object)"javac.classpath"), "web-module-libraries");
            ArrayList<ClassPathSupport.Item> cpItems = new ArrayList<ClassPathSupport.Item>();
            while (items.hasNext()) {
                ClassPathSupport.Item cpti = (ClassPathSupport.Item)items.next();
                String propertyName = cpti.getReference();
                if (propertyName == null) continue;
                String libname = propertyName.substring("${libs.".length());
                if (libname.indexOf(".classpath}") != -1) {
                    libname = libname.substring(0, libname.indexOf(".classpath}"));
                }
                if ("servlet24".equals(libname) || "jsp20".equals(libname)) continue;
                cpItems.add(cpti);
            }
            String[] javac_cp = cs.encodeToStrings(cpItems, "web-module-libraries");
            props.setProperty("javac.classpath", javac_cp);
        }
        if (putProps) {
            this.helper.putProperties("nbproject/project.properties", props);
        }
        ProjectManager.getDefault().saveProject(this.project);
        refHelper = this;
        synchronized (refHelper) {
            this.isCurrent = Boolean.TRUE;
        }
        if (this.projectUpdateListener != null) {
            this.projectUpdateListener.projectUpdated();
        }
        try {
            FileObject prjFO = this.project.getProjectDirectory();
            FileObject confDirFO = prjFO.createFolder("conf");
            FileObject manifest = FileUtil.createData((FileObject)confDirFO, (String)"MANIFEST");
            FileLock lock = manifest.lock();
            InputStream bufIn = UpdateProjectImpl.class.getResourceAsStream("/org/netbeans/modules/web/project/ui/resources/MANIFEST.MF");
            OutputStream bufOut = null;
            try {
                lock = manifest.lock();
                bufOut = manifest.getOutputStream(lock);
                FileUtil.copy((InputStream)bufIn, (OutputStream)bufOut);
            }
            finally {
                if (bufIn != null) {
                    bufIn.close();
                }
                if (bufOut != null) {
                    bufOut.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String ns;
            int version = 1;
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
            if (oldRoot == null) {
                version = 2;
                oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
            }
            String string = ns = version == 1 ? "http://www.netbeans.org/ns/web-project/1" : "http://www.netbeans.org/ns/web-project/2";
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "data");
                XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/web-project/3");
                if (version == 1) {
                    Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    root.setAttribute("id", "src.dir");
                    sourceRoots.appendChild(root);
                    newRoot.appendChild(sourceRoots);
                    Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    root.setAttribute("id", "test.src.dir");
                    testRoots.appendChild(root);
                    newRoot.appendChild(testRoots);
                }
                if (version == 1 || version == 2) {
                    NodeList libList = newRoot.getElementsByTagNameNS(ns, TAG_LIBRARY);
                    for (int i = 0; i < libList.getLength(); ++i) {
                        if (libList.item(i).getNodeType() != 1) continue;
                        Element library = (Element)libList.item(i);
                        Node webFile = library.getElementsByTagNameNS(ns, TAG_FILE).item(0);
                        String webFileText = XMLUtil.findText((Node)webFile);
                        if (!(webFileText = webFileText.substring(2, webFileText.length() - 1)).startsWith("lib.")) continue;
                        String libName = webFileText.substring(6, webFileText.indexOf(".classpath"));
                        List roots = LibraryManager.getDefault().getLibrary(libName).getContent("classpath");
                        ArrayList<FileObject> files = new ArrayList<FileObject>();
                        ArrayList<FileObject> dirs = new ArrayList<FileObject>();
                        for (URL rootUrl : roots) {
                            FileObject root = URLMapper.findFileObject((URL)rootUrl);
                            if ("jar".equals(rootUrl.getProtocol())) {
                                root = FileUtil.getArchiveFile((FileObject)root);
                            }
                            if (root == null) continue;
                            if (root.isData()) {
                                files.add(root);
                                continue;
                            }
                            dirs.add(root);
                        }
                        if (files.size() > 0) {
                            library.setAttribute(ATTR_FILES, "" + files.size());
                        }
                        if (dirs.size() <= 0) continue;
                        library.setAttribute(ATTR_DIRS, "" + dirs.size());
                    }
                }
                this.cachedElement = UpdateProjectImpl.updateMinAntVersion(newRoot, doc);
            }
        }
        return this.cachedElement;
    }

    public synchronized EditableProperties getUpdatedProjectProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = this.helper.getProperties("nbproject/project.properties");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "javadoc.additionalparam", "");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "annotation.processing.enabled", "true");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "annotation.processing.enabled.in.editor", "true");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "annotation.processing.run.all.processors", "true");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "annotation.processing.processors.list", "");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "javac.processorpath", "${javac.classpath}");
            UpdateProjectImpl.ensureValueExists(this.cachedProperties, "javac.test.processorpath", "${javac.test.classpath}");
        }
        return this.cachedProperties;
    }

    private static void ensureValueExists(EditableProperties prop, String property, String defaultValue) {
        if (prop.get((Object)property) == null) {
            prop.put(property, defaultValue);
        }
    }

    private static Element updateMinAntVersion(Element root, Document doc) {
        Element me;
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", TAG_MINIMUM_ANT_VERSION);
        if (list.getLength() == 1 && (list = (me = (Element)list.item(0)).getChildNodes()).getLength() == 1) {
            me.replaceChild(doc.createTextNode("1.6.5"), list.item(0));
            return root;
        }
        assert (false) : "Invalid project file";
        return root;
    }

    private boolean showUpdateDialog() {
        JButton updateOption = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        updateOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateProjectImpl.class, (String)"AD_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
    }

    public void setProjectUpdateListener(ProjectUpdateListener l) {
        this.projectUpdateListener = l;
    }

    public static interface ProjectUpdateListener {
        public void projectUpdated();
    }
}

