/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ShellValidationSupport {
    protected static final ShellValidationStatus NOSHELL = new ShellValidationStatus(null, Arrays.asList("No shell"), null);
    protected static final ShellValidationStatus VALID = new ShellValidationStatus(null, null, null);

    private ShellValidationSupport() {
    }

    public static ShellValidationStatus getValidationStatus(Shell shell) {
        if (shell == null) {
            return NOSHELL;
        }
        if (shell.type == Shell.ShellType.CYGWIN) {
            return ShellValidationSupport.validateCygwinShell(shell);
        }
        return VALID;
    }

    private static ShellValidationStatus validateCygwinShell(Shell shell) {
        ProcessUtils.ExitStatus exitStatus;
        assert (shell != null && shell.type == Shell.ShellType.CYGWIN);
        ArrayList<String> validationErrors = new ArrayList<String>();
        ArrayList<String> validationWarnings = new ArrayList<String>();
        String jdkBitness = System.getProperty("os.arch");
        if (jdkBitness == null) {
            jdkBitness = "";
        }
        String cygwinBitness = "";
        File uname_exe = new File(shell.bindir, "uname.exe");
        if (uname_exe.exists() && (exitStatus = ProcessUtils.execute(new ProcessBuilder(uname_exe.getPath(), "-m"))).isOK()) {
            cygwinBitness = exitStatus.getOutputString().trim();
        }
        if (cygwinBitness.equals("i686") && !jdkBitness.equals("x86")) {
            validationWarnings.add(NbBundle.getMessage(ShellValidationSupport.class, (String)"ShellValidationSupport.ValidationWarning.Cygwin32OnJDK64"));
        } else if (cygwinBitness.equals("x86_64") && jdkBitness.equals("x86")) {
            validationWarnings.add(NbBundle.getMessage(ShellValidationSupport.class, (String)"ShellValidationSupport.ValidationWarning.Cygwin64OnJDK32"));
        }
        File mount_util = new File(shell.bindir, "mount.exe");
        File cygpath_util = new File(shell.bindir, "cygpath.exe");
        if (!mount_util.exists()) {
            validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", mount_util.getAbsolutePath()));
        }
        if (!cygpath_util.exists()) {
            validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", cygpath_util.getAbsolutePath()));
        }
        ProcessBuilder pb = new ProcessBuilder(mount_util.getAbsolutePath());
        ProcessUtils.ExitStatus exitStatus2 = ProcessUtils.execute(pb);
        List<String> output = exitStatus2.getOutputLines();
        if (!exitStatus2.isOK()) {
            validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.validationFailed", shell.bindir.getAbsolutePath()));
        }
        Pattern pattern = Pattern.compile("(.*) on (/.*) type .*");
        boolean rootIsMounted = false;
        for (String line : output) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            String winpath = m.group(1);
            File winfile = new File(winpath);
            String cygpath = m.group(2);
            if (cygpath.equals("/")) {
                rootIsMounted = true;
            }
            if (!winfile.exists()) {
                validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.absentMountPoint", winpath, cygpath));
                continue;
            }
            if (!cygpath.startsWith("/usr")) continue;
            String p1 = (winfile.getParentFile().getAbsolutePath() + '\\').toLowerCase();
            String p2 = (shell.bindir.getParentFile().getAbsolutePath() + '\\').toLowerCase();
            if (p2.startsWith(p1)) continue;
            validationWarnings.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.wrongMountPoint", winpath, cygpath));
        }
        if (!rootIsMounted) {
            validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.rootIsNotMounted", new String[0]));
        }
        return new ShellValidationStatus(shell, validationErrors, validationWarnings);
    }

    public static boolean confirm(ShellValidationStatus status) {
        return ShellValidationSupport.confirm(null, null, status);
    }

    public static boolean confirm(String header, String footer, ShellValidationStatus status) {
        if (status == null || status == NOSHELL) {
            if (Boolean.getBoolean("nativeexecution.mode.unittest") || "true".equals(System.getProperty("cnd.command.line.utility"))) {
                System.err.println(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.NoShell", new String[0]));
            } else {
                NativeExecutionUserNotification.getDefault().notify(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.NoShell", new String[0]), NativeExecutionUserNotification.Descriptor.ERROR);
            }
            return false;
        }
        if (status.isValid() && !status.hasWarnings()) {
            return true;
        }
        String key = status.shell.toString();
        String allowBroken = NbPreferences.forModule(WindowsSupport.class).get(key, "no");
        if ("yes".equals(allowBroken)) {
            return true;
        }
        Object response = null;
        if (Boolean.getBoolean("nativeexecution.mode.unittest")) {
            System.err.println(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.ErrorDialogTitle", "cygwin"));
            System.err.println(header);
            for (String error : status.shell.getValidationStatus().getErrors()) {
                System.err.println(error);
            }
            System.err.println(footer);
            return true;
        }
        return NativeExecutionUserNotification.getDefault().confirmShellStatusValiation(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.ErrorDialogTitle", "cygwin"), header, footer, status.shell);
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ShellValidationSupport.class, (String)key, (Object[])params);
    }

    public static class ShellValidationStatus {
        private final List<String> errors = new ArrayList<String>();
        private final List<String> warnings = new ArrayList<String>();
        private final Shell shell;

        private ShellValidationStatus(Shell shell, List<String> errors, List<String> warnings) {
            if (errors != null) {
                this.errors.addAll(errors);
            }
            if (warnings != null) {
                this.warnings.addAll(warnings);
            }
            this.shell = shell;
        }

        public boolean isValid() {
            return this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public List<String> getWarnings() {
            return Collections.unmodifiableList(this.warnings);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

