/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.AddStylesheetLinkHintFix;
import org.netbeans.modules.html.editor.hints.css.CreateRuleInStylesheet;
import org.netbeans.modules.html.editor.hints.css.HintContext;
import org.openide.filesystems.FileObject;

public class MissingCssElement
extends Hint {
    private final HintContext hintContext;
    private List<HintFix> computedFixes;

    public MissingCssElement(Rule rule, String msg, HtmlRuleContext context, OffsetRange range, HintContext hintContext) {
        super(rule, msg, context.getFile(), range, Collections.emptyList(), 10);
        this.hintContext = hintContext;
    }

    public synchronized List<HintFix> getFixes() {
        if (this.computedFixes == null) {
            this.computedFixes = this.createFixes();
        }
        return Collections.unmodifiableList(this.computedFixes);
    }

    private List<HintFix> createFixes() {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        FileObject sourceFile = this.getFile();
        if (this.hintContext.getElement2files().get(this.hintContext.getPureElementName()) != null) {
            for (FileObject file : this.hintContext.getElement2files().get(this.hintContext.getPureElementName())) {
                fixes.add(new AddStylesheetLinkHintFix(sourceFile, file));
            }
        } else if (!this.hintContext.getAllStylesheets().isEmpty()) {
            for (FileObject stylesheet : this.hintContext.getAllStylesheets()) {
                fixes.add(new CreateRuleInStylesheet(sourceFile, stylesheet, this.hintContext.getElementName(), !this.hintContext.getReferredFiles().contains(stylesheet), false));
            }
        } else {
            fixes.add(new CreateRuleInStylesheet(sourceFile, null, this.hintContext.getElementName(), true, true));
        }
        return fixes;
    }
}

