/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerContainerDetail;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.node.StatefulDockerContainer;
import org.netbeans.modules.docker.ui.output.ExceptionHandler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public abstract class AbstractContainerAction
extends NodeAction
implements ExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractContainerAction.class.getName());
    private final RequestProcessor requestProcessor = new RequestProcessor(AbstractContainerAction.class);
    private final String name;

    public AbstractContainerAction(String name) {
        this.name = name;
    }

    protected abstract void performAction(DockerContainer var1) throws DockerException;

    protected abstract String getProgressMessage(DockerContainer var1);

    protected boolean isEnabled(DockerContainerDetail detail) {
        return true;
    }

    protected final void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            final StatefulDockerContainer container = (StatefulDockerContainer)node.getLookup().lookup(StatefulDockerContainer.class);
            if (container == null) continue;
            final ProgressHandle handle = ProgressHandle.createHandle((String)this.getProgressMessage(container.getContainer()));
            handle.start();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractContainerAction.this.performAction(container.getContainer());
                    }
                    catch (Exception ex) {
                        AbstractContainerAction.this.handleException(ex);
                    }
                    finally {
                        handle.finish();
                    }
                }
            };
            this.requestProcessor.post(task);
        }
    }

    protected final boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            StatefulDockerContainer container = (StatefulDockerContainer)node.getLookup().lookup(StatefulDockerContainer.class);
            if (container != null && this.isEnabled(container.getDetail())) continue;
            return false;
        }
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected final boolean asynchronous() {
        return false;
    }

    @Override
    public final void handleException(Exception ex) {
        LOGGER.log(Level.INFO, null, ex);
        String msg = ex.getLocalizedMessage();
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }
}

