/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.openide.util.NbPreferences;

public final class CodeceptionOptions {
    private static final String PREFERENCES_PATH = "codeception";
    private static final CodeceptionOptions INSTANCE = new CodeceptionOptions();
    private static final String CODECEPTION_PATH = "codeception.path";
    private volatile boolean codeceptionSearched = false;

    public static CodeceptionOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getCodeceptionPath() {
        List scripts;
        String codeceptionPath = this.getPreferences().get(CODECEPTION_PATH, null);
        if (codeceptionPath == null && !this.codeceptionSearched && !(scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"codecept", Codecept.SCRIPT_NAME_LONG, "codecept.phar"})).isEmpty()) {
            codeceptionPath = (String)scripts.get(0);
            this.setCodeceptionPath(codeceptionPath);
        }
        return codeceptionPath;
    }

    public void setCodeceptionPath(String codeceptionPath) {
        this.getPreferences().put(CODECEPTION_PATH, codeceptionPath);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(CodeceptionOptions.class).node(PREFERENCES_PATH);
    }
}

