/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.runtime.JSRuntime;

public class FloatParser {
    private final String input;
    private int pos;
    private boolean isNaN;
    private final double value;
    private final BranchProfile exponentBranch;

    public FloatParser(String s, BranchProfile exponentBranch) {
        this.input = s;
        this.pos = 0;
        this.isNaN = false;
        this.exponentBranch = exponentBranch;
        this.value = this.parse();
    }

    public double getResult() {
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary
    private double parse() {
        this.strDecimalLiteral();
        if (this.isNaN) {
            return Double.NaN;
        }
        return this.parseValidSubstring();
    }

    @CompilerDirectives.TruffleBoundary
    private double parseValidSubstring() {
        return Double.parseDouble(this.input.substring(0, this.pos));
    }

    private void strDecimalLiteral() {
        char currentChar = this.current();
        if (currentChar == '+' || currentChar == '-') {
            this.next();
            currentChar = this.current();
        }
        if (JSRuntime.isAsciiDigit(currentChar) || currentChar == '.') {
            this.strUnsignedDecimalLiteral();
        } else {
            this.isNaN = true;
        }
    }

    private void strUnsignedDecimalLiteral() {
        if (JSRuntime.isAsciiDigit(this.current())) {
            this.decimalDigits();
        }
        int prevPos = this.pos;
        if (this.hasNext() && this.current() == '.') {
            this.next();
            if (JSRuntime.isAsciiDigit(this.current())) {
                this.decimalDigits();
            }
        }
        if (this.isNaN) {
            this.pos = prevPos;
            this.isNaN = false;
            return;
        }
        prevPos = this.pos;
        if (this.isExponentPart()) {
            this.exponentPart();
        }
        if (this.isNaN) {
            this.pos = prevPos;
            this.isNaN = false;
            return;
        }
    }

    private void next() {
        ++this.pos;
    }

    private char current() {
        if (this.hasNext()) {
            return this.input.charAt(this.pos);
        }
        return '\u0000';
    }

    private boolean hasNext() {
        return this.pos < this.input.length();
    }

    private void exponentPart() {
        this.exponentBranch.enter();
        assert (this.current() == 'e' || this.current() == 'E');
        this.next();
        char currentChar = this.current();
        if (JSRuntime.isAsciiDigit(currentChar)) {
            this.decimalDigits();
        } else if (currentChar == '+' || currentChar == '-') {
            this.next();
            this.decimalDigits();
        } else {
            this.isNaN = true;
        }
    }

    private boolean isExponentPart() {
        if (this.hasNext()) {
            char firstChar = this.current();
            return firstChar == 'e' || firstChar == 'E';
        }
        return false;
    }

    private void decimalDigits() {
        char currentChar = this.current();
        boolean valid = false;
        while (JSRuntime.isAsciiDigit(currentChar) && this.hasNext()) {
            valid = true;
            this.next();
            currentChar = this.current();
        }
        if (!valid) {
            this.isNaN = true;
        }
    }
}

