/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Set;

public class CompoundWriteElementNode
extends WriteElementNode {
    @Node.Child
    private JSWriteFrameSlotNode writeIndexNode;

    public static CompoundWriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSWriteFrameSlotNode writeIndexNode, JSContext context, boolean isStrict) {
        return CompoundWriteElementNode.create(targetNode, indexNode, valueNode, writeIndexNode, context, isStrict, false);
    }

    private static CompoundWriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSWriteFrameSlotNode writeIndexNode, JSContext context, boolean isStrict, boolean writeOwn) {
        return new CompoundWriteElementNode(targetNode, indexNode, valueNode, writeIndexNode, context, isStrict, writeOwn);
    }

    protected CompoundWriteElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSWriteFrameSlotNode writeIndexNode, JSContext context, boolean isStrict, boolean writeOwn) {
        super(targetNode, indexNode, valueNode, context, isStrict, writeOwn);
        this.writeIndexNode = writeIndexNode;
    }

    @Override
    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, Object index, Object receiver) {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndex(frame, target, this.writeIndex(frame, this.toArrayIndexNode().execute(index)), receiver);
    }

    @Override
    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, int index, Object receiver) {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndex(frame, target, this.writeIndex(frame, index), receiver);
    }

    @Override
    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndexInt(frame, target, this.writeIndex(frame, this.toArrayIndexNode().execute(index)), receiver);
    }

    @Override
    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndexInt(frame, target, this.writeIndex(frame, index), receiver);
    }

    @Override
    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndexDouble(frame, target, this.writeIndex(frame, this.toArrayIndexNode().execute(index)), receiver);
    }

    @Override
    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        this.requireObjectCoercible(target, index);
        return super.executeWithTargetAndIndexDouble(frame, target, this.writeIndex(frame, index), receiver);
    }

    private Object writeIndex(VirtualFrame frame, Object index) {
        if (this.writeIndexNode != null) {
            this.writeIndexNode.executeWrite(frame, index);
        }
        return index;
    }

    private int writeIndex(VirtualFrame frame, int index) {
        if (this.writeIndexNode != null) {
            this.writeIndexNode.executeWrite(frame, index);
        }
        return index;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return CompoundWriteElementNode.create(CompoundWriteElementNode.cloneUninitialized(this.targetNode, materializedTags), CompoundWriteElementNode.cloneUninitialized(this.indexNode, materializedTags), CompoundWriteElementNode.cloneUninitialized(this.valueNode, materializedTags), CompoundWriteElementNode.cloneUninitialized(this.writeIndexNode, materializedTags), this.getContext(), this.isStrict(), this.writeOwn());
    }

    @Override
    protected WriteElementNode createMaterialized(JavaScriptNode newTarget, JavaScriptNode newIndex, JavaScriptNode newValue) {
        return CompoundWriteElementNode.create(newTarget, newIndex, newValue, this.writeIndexNode, this.getContext(), this.isStrict(), this.writeOwn());
    }
}

