/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.DataViewPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.function.Function;

public final class JSDataView
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "DataView";
    public static final String PROTOTYPE_NAME = "DataView.prototype";
    public static final JSDataView INSTANCE = new JSDataView();
    private static final String BYTE_LENGTH = "byteLength";
    private static final String BUFFER = "buffer";
    private static final String BYTE_OFFSET = "byteOffset";

    public static int typedArrayGetLength(DynamicObject thisObj) {
        assert (JSDataView.isJSDataView(thisObj));
        return JSDataViewObject.getLength(thisObj);
    }

    public static int typedArrayGetOffset(DynamicObject thisObj) {
        assert (JSDataView.isJSDataView(thisObj));
        return JSDataViewObject.getOffset(thisObj);
    }

    private JSDataView() {
    }

    public static DynamicObject getArrayBuffer(DynamicObject thisObj) {
        assert (JSDataView.isJSDataView(thisObj));
        return JSDataViewObject.getArrayBuffer(thisObj);
    }

    public static DynamicObject createDataView(JSContext context, DynamicObject arrayBuffer, int offset, int length) {
        assert (offset >= 0 && offset + length <= (JSArrayBuffer.isJSDirectOrSharedArrayBuffer(arrayBuffer) ? JSArrayBuffer.getDirectByteLength(arrayBuffer) : JSArrayBuffer.getByteLength(arrayBuffer)));
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getDataViewFactory();
        JSDataViewObject dataView = JSDataViewObject.create(realm, factory, (JSArrayBufferObject)arrayBuffer, length, offset);
        assert (JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer) || JSArrayBuffer.isJSDirectOrSharedArrayBuffer(arrayBuffer));
        assert (JSDataView.isJSDataView((Object)dataView));
        return context.trackAllocation(dataView);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(context, prototype, ctor);
        JSDataView.putGetters(realm, prototype);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, DataViewPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    private static void putGetters(JSRealm realm, DynamicObject prototype) {
        JSDataView.putGetter(realm, prototype, BUFFER, JSContext.BuiltinFunctionKey.DataViewBuffer, view -> JSDataView.getArrayBuffer(view));
        JSDataView.putGetter(realm, prototype, BYTE_LENGTH, JSContext.BuiltinFunctionKey.DataViewByteLength, view -> JSDataView.typedArrayGetLengthChecked(view));
        JSDataView.putGetter(realm, prototype, BYTE_OFFSET, JSContext.BuiltinFunctionKey.DataViewByteOffset, view -> JSDataView.typedArrayGetOffsetChecked(view));
    }

    public static int typedArrayGetLengthChecked(DynamicObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(JSDataView.getArrayBuffer(thisObj))) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        return JSDataView.typedArrayGetLength(thisObj);
    }

    public static int typedArrayGetOffsetChecked(DynamicObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(JSDataView.getArrayBuffer(thisObj))) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        return JSDataView.typedArrayGetOffset(thisObj);
    }

    private static void putGetter(JSRealm realm, DynamicObject prototype, String name, JSContext.BuiltinFunctionKey key, final Function<DynamicObject, Object> function) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(key, c -> JSFunctionData.createCallOnly(c, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSDataView.isJSDataView(obj)) {
                    return function.apply((JSDataViewObject)((Object)obj));
                }
                throw Errors.createTypeErrorNotADataView();
            }
        }), 0, "get " + name));
        DynamicObject getter = JSFunction.create(realm, getterData);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)name, getter, Undefined.instance);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape childTree = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return childTree;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSDataView(Object obj) {
        return obj instanceof JSDataViewObject;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDataViewPrototype();
    }
}

