/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.PerformanceBuiltins;
import com.oracle.truffle.js.builtins.Test262Builtins;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSTest262 {
    public static final String CLASS_NAME = "Test262";
    public static final String GLOBAL_PROPERTY_NAME = "$262";

    private JSTest262() {
    }

    public static DynamicObject create(JSRealm realm) {
        DynamicObject obj = JSOrdinary.createInit(realm);
        JSObjectUtil.putDataProperty(obj, "createRealm", realm.lookupFunction(Test262Builtins.BUILTINS, "createRealm"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(obj, "detachArrayBuffer", realm.lookupFunction(Test262Builtins.BUILTINS, "detachArrayBuffer"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(obj, "evalScript", realm.lookupFunction(Test262Builtins.BUILTINS, "evalScript"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(obj, "global", realm.getGlobalObject(), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(obj, "gc", realm.lookupFunction(Test262Builtins.BUILTINS, "gc"), JSAttributes.getDefaultNotEnumerable());
        DynamicObject agent = JSTest262.createAgent(realm);
        JSObjectUtil.putDataProperty(obj, "agent", agent, JSAttributes.getDefaultNotEnumerable());
        return obj;
    }

    private static DynamicObject createAgent(JSRealm realm) {
        DynamicObject agent = JSOrdinary.createInit(realm);
        JSObjectUtil.putDataProperty(agent, "start", realm.lookupFunction(Test262Builtins.BUILTINS, "agentStart"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "broadcast", realm.lookupFunction(Test262Builtins.BUILTINS, "agentBroadcast"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "getReport", realm.lookupFunction(Test262Builtins.BUILTINS, "agentGetReport"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "sleep", realm.lookupFunction(Test262Builtins.BUILTINS, "agentSleep"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "monotonicNow", realm.lookupFunction(PerformanceBuiltins.BUILTINS, "now"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "receiveBroadcast", realm.lookupFunction(Test262Builtins.BUILTINS, "agentReceiveBroadcast"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "report", realm.lookupFunction(Test262Builtins.BUILTINS, "agentReport"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(agent, "leaving", realm.lookupFunction(Test262Builtins.BUILTINS, "agentLeaving"), JSAttributes.getDefaultNotEnumerable());
        return agent;
    }
}

