/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.swing.AbstractAction;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.windows.CloneableOpenSupport;

public class ViewConfigAction
extends AbstractAction {
    private final HudsonJob job;

    public ViewConfigAction(HudsonJob job) {
        super(Bundle.ViewConfigAction_label());
        this.job = job;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new ConfigXmlEditor(new EnvImpl(this.job.getInstance().getUrl(), this.job.getUrl() + "config.xml")).open();
    }

    private static final class ConfigXmlEditor
    extends CloneableEditorSupport {
        private final EnvImpl envImpl;

        ConfigXmlEditor(EnvImpl env) {
            super((CloneableEditorSupport.Env)env);
            this.envImpl = env;
        }

        protected boolean asynchronousOpen() {
            return true;
        }

        protected String messageSave() {
            return null;
        }

        protected String messageName() {
            return this.envImpl.url.replaceFirst("^.+/([^/]+)/config[.]xml$", "$1");
        }

        protected String messageToolTip() {
            return this.envImpl.url;
        }

        protected String messageOpening() {
            return null;
        }

        protected String messageOpened() {
            return null;
        }
    }

    private static final class EnvImpl
    implements CloneableEditorSupport.Env {
        private static final long serialVersionUID = 1L;
        private final String home;
        private final String url;

        EnvImpl(String home, String url) {
            this.home = home;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream inputStream() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                URLConnection conn = new ConnectionBuilder().homeURL(new URL(this.home)).url(this.url).connection();
                try (InputStream is = conn.getInputStream();){
                    FileUtil.copy((InputStream)is, (OutputStream)baos);
                }
            }
            catch (IOException x) {
                if (Exceptions.findLocalizedMessage((Throwable)x) == null) {
                    Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.ViewConfigAction_could_not_connect(this.url));
                }
                throw x;
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }

        public OutputStream outputStream() throws IOException {
            throw new IOException();
        }

        public Date getTime() {
            return new Date();
        }

        public String getMimeType() {
            return "text/xml";
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
        }

        public boolean isValid() {
            return true;
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return new ConfigXmlEditor(this);
        }
    }
}

