/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.options;

import java.io.File;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.symfony2.options.Bundle;
import org.netbeans.modules.php.symfony2.options.SymfonyOptions;

public final class SymfonyOptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public SymfonyOptionsValidator validate() {
        if (SymfonyOptions.getInstance().isUseInstaller()) {
            this.validateInstaller();
        } else {
            this.validateSandbox();
        }
        return this;
    }

    public SymfonyOptionsValidator validate(boolean useInstaller, String installer, String sandbox) {
        if (useInstaller) {
            return this.validateInstaller(installer);
        }
        return this.validateSandbox(sandbox);
    }

    public SymfonyOptionsValidator validateInstaller() {
        return this.validateInstaller(SymfonyOptions.getInstance().getInstaller());
    }

    public SymfonyOptionsValidator validateInstaller(String installer) {
        String warning = PhpExecutableValidator.validateCommand((String)installer, (String)Bundle.SymfonyOptionsValidator_installer());
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"installer", warning));
        }
        return this;
    }

    public SymfonyOptionsValidator validateSandbox() {
        return this.validateSandbox(SymfonyOptions.getInstance().getSandbox());
    }

    public SymfonyOptionsValidator validateSandbox(@NullAllowed String sandbox) {
        String warning = FileUtils.validateFile((String)Bundle.SymfonyOptionsValidator_sandbox(), (String)sandbox, (boolean)false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"sandbox", warning));
        } else if (!new File(sandbox).getName().toLowerCase().endsWith(".zip")) {
            this.result.addWarning(new ValidationResult.Message((Object)"sandbox", Bundle.SymfonyOptionsValidator_sandbox_notZip()));
        }
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }
}

