/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.customizer;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.symfony2.ui.customizer.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SymfonyCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -464365465761315L;
    private final FileObject sources;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton appDirBrowseButton;
    private JLabel appDirLabel;
    private JTextField appDirTextField;
    private JCheckBox enabledCheckBox;
    private JLabel enabledInfoLabel;
    private JCheckBox ignoreCacheDirectoryCheckBox;
    private JLabel infoLabel;
    private JLabel optionsLabel;

    public SymfonyCustomizerPanel(FileObject sources) {
        this.sources = sources;
        this.initComponents();
        this.init();
        this.setFieldsEnabled(this.enabledCheckBox.isSelected());
    }

    private void init() {
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SymfonyCustomizerPanel.this.fireChange();
                SymfonyCustomizerPanel.this.setFieldsEnabled(e.getStateChange() == 1);
            }
        });
        this.appDirTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                SymfonyCustomizerPanel.this.fireChange();
            }
        });
    }

    public boolean isSupportEnabled() {
        return this.enabledCheckBox.isSelected();
    }

    public void setSupportEnabled(boolean enabled) {
        this.enabledCheckBox.setSelected(enabled);
    }

    public String getAppDirectory() {
        return this.appDirTextField.getText().replace(File.separatorChar, '/');
    }

    public void setAppDirectory(String appDir) {
        this.appDirTextField.setText(appDir.replace('/', File.separatorChar));
    }

    public boolean isIgnoreCacheDirectory() {
        return this.ignoreCacheDirectoryCheckBox.isSelected();
    }

    public void setIgnoreCacheDirectory(boolean ignore) {
        this.ignoreCacheDirectoryCheckBox.setSelected(ignore);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    final void setFieldsEnabled(boolean enabled) {
        this.appDirTextField.setEnabled(enabled);
        this.appDirBrowseButton.setEnabled(enabled);
        this.ignoreCacheDirectoryCheckBox.setEnabled(enabled);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.enabledCheckBox = new JCheckBox();
        this.enabledInfoLabel = new JLabel();
        this.appDirLabel = new JLabel();
        this.appDirTextField = new JTextField();
        this.appDirBrowseButton = new JButton();
        this.ignoreCacheDirectoryCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.infoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.optionsLabel.text"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SymfonyCustomizerPanel.this.optionsLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SymfonyCustomizerPanel.this.optionsLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.enabledCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.enabledInfoLabel, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.enabledInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.appDirLabel, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.appDirLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.appDirBrowseButton, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.appDirBrowseButton.text"));
        this.appDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymfonyCustomizerPanel.this.appDirBrowseButtonActionPerformed(evt);
            }
        });
        this.ignoreCacheDirectoryCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreCacheDirectoryCheckBox, (String)NbBundle.getMessage(SymfonyCustomizerPanel.class, (String)"SymfonyCustomizerPanel.ignoreCacheDirectoryCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.appDirLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.appDirTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.appDirBrowseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreCacheDirectoryCheckBox).addComponent(this.enabledCheckBox)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enabledInfoLabel).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.optionsLabel, -2, -1, -2)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enabledInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.appDirLabel).addComponent(this.appDirTextField, -2, -1, -2).addComponent(this.appDirBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ignoreCacheDirectoryCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.infoLabel).addComponent(this.optionsLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        UiUtils.showOptions((String)"FrameworksAndTools/Symfony2");
    }

    private void appDirBrowseButtonActionPerformed(ActionEvent evt) {
        File appDir = new FileChooserBuilder(SymfonyCustomizerPanel.class).setTitle(Bundle.SymfonyCustomizerPanel_browseAppDir_title()).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.sources)).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (appDir != null) {
            FileObject fo = FileUtil.toFileObject((File)(appDir = FileUtil.normalizeFile((File)appDir)));
            if (FileUtil.isParentOf((FileObject)this.sources, (FileObject)fo)) {
                String relativePath = FileUtil.getRelativePath((FileObject)this.sources, (FileObject)fo);
                assert (relativePath != null) : this.sources + " not parent of " + fo;
                this.setAppDirectory(relativePath);
            } else {
                this.appDirTextField.setText(appDir.getAbsolutePath());
            }
        }
    }
}

