/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.LocaleToCharsetMap;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

class ExceptionHandler
extends ServletWrapper {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.resources");

    ExceptionHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.exceptionHandler";
    }

    public void doService(Request req, Response res) throws Exception {
        Object out;
        Throwable cause;
        String msg = (String)req.getAttribute("javax.servlet.error.message");
        String errorURI = res.getErrorURI();
        Throwable e = (Throwable)req.getAttribute("tomcat.servlet.error.throwable");
        if (e == null) {
            System.out.println("ASSERT: Exception handler without exception");
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        String charset = LocaleToCharsetMap.getCharset(Locale.getDefault());
        if (charset == null || charset.equalsIgnoreCase("ISO-8859-1")) {
            res.setContentType("text/html");
        } else {
            res.setContentType("text/html; charset=" + charset);
        }
        res.setStatus(500);
        StringBuffer buf = new StringBuffer();
        buf.append("<h1>");
        if (errorURI != null) {
            buf.append(sm.getString("defaulterrorpage.includedservlet")).append(" ");
        } else {
            buf.append("Error: ");
        }
        buf.append(500);
        buf.append("</h1>\r\n");
        buf.append("<h2>").append(sm.getString("defaulterrorpage.location")).append(" ").append(RequestUtil.filter(req.getRequestURI())).append("</h2>");
        if (errorURI != null && this.contextM.getShowDebugInfo()) {
            buf.append("\r\n<h2>").append(sm.getString("defaulterrorpage.errorlocation")).append(" ").append(RequestUtil.filter(errorURI)).append("</h2>");
        }
        buf.append("<b>").append(sm.getString("defaulterrorpage.internalservleterror"));
        if (this.contextM.getShowDebugInfo()) {
            buf.append("</b><br>");
            buf.append("<pre>");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            buf.append(sw.toString());
            buf.append("</pre>\r\n");
        } else {
            buf.append("</b> ").append(e.getMessage()).append("<br><br>\r\n");
        }
        if (e instanceof ServletException && (cause = ((ServletException)e).getRootCause()) != null) {
            buf.append("<b>").append(sm.getString("defaulterrorpage.rootcause"));
            if (this.contextM.getShowDebugInfo()) {
                buf.append("</b>\r\n");
                buf.append("<pre>");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                buf.append(sw.toString());
                buf.append("</pre>\r\n");
            } else {
                buf.append("</b> ").append(cause.getMessage());
            }
        }
        buf.append("\r\n");
        if (res.isUsingStream()) {
            out = res.getOutputStream();
            out.print(buf.toString());
        } else {
            out = res.getWriter();
            ((PrintWriter)out).print(buf.toString());
        }
    }
}

