/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import org.apache.tomcat.util.MessageBytes;
import org.apache.tomcat.util.StringManager;

public class Ascii {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];

    public static int toUpper(int c) {
        return toUpper[c & 0xFF] & 0xFF;
    }

    public static int toLower(int c) {
        return toLower[c & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int c) {
        return isAlpha[c & 0xFF];
    }

    public static boolean isUpper(int c) {
        return isUpper[c & 0xFF];
    }

    public static boolean isLower(int c) {
        return isLower[c & 0xFF];
    }

    public static boolean isWhite(int c) {
        return isWhite[c & 0xFF];
    }

    public static boolean isDigit(int c) {
        return isDigit[c & 0xFF];
    }

    public static int parseInt(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            String msg = sm.getString("ascii.parseInit.nfe", (Object)b);
            throw new NumberFormatException(msg);
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                StringManager sm = StringManager.getManager("org.apache.tomcat.util");
                String msg = sm.getString("ascii.parseInit.nfe", (Object)b);
                throw new NumberFormatException(msg);
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static boolean equalsIgnoreCase(String str, MessageBytes mB) {
        byte[] b = mB.getBytes();
        int off = mB.getOffset();
        int len = mB.getLength();
        if (str != null) {
            String s = str;
            if (len != s.length()) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (Ascii.toLower(b[off++]) != Ascii.toLower(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static {
        int i = 0;
        while (i < 256) {
            Ascii.toUpper[i] = (byte)i;
            Ascii.toLower[i] = (byte)i;
            ++i;
        }
        int lc = 97;
        while (lc <= 122) {
            int uc = lc + 65 - 97;
            Ascii.toUpper[lc] = (byte)uc;
            Ascii.toLower[uc] = (byte)lc;
            Ascii.isAlpha[lc] = true;
            Ascii.isAlpha[uc] = true;
            Ascii.isLower[lc] = true;
            Ascii.isUpper[uc] = true;
            ++lc;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        int d = 48;
        while (d <= 57) {
            Ascii.isDigit[d] = true;
            ++d;
        }
    }
}

