/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.debuggingview;

import java.awt.Image;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.ThreadsCollector;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public class DebuggingViewSupportImpl
extends DebuggingView.DVSupport
implements CPPLiteDebugger.StateListener,
ThreadsCollector.StateListener {
    static final String THREAD_SUSPENDED_ICON = "org/netbeans/modules/debugger/resources/threadsView/thread_suspended_16.png";
    static final String THREAD_RUNNING_ICON = "org/netbeans/modules/debugger/resources/threadsView/thread_running_16.png";
    private final CPPLiteDebugger debugger;
    private final Session session;

    public DebuggingViewSupportImpl(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)contextProvider.lookupFirst(null, CPPLiteDebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.debugger.addStateListener((CPPLiteDebugger.StateListener)WeakListeners.create(CPPLiteDebugger.StateListener.class, (EventListener)this, (Object)this.debugger));
        this.debugger.getThreads().addStateListener((ThreadsCollector.StateListener)WeakListeners.create(ThreadsCollector.StateListener.class, (EventListener)this, (Object)this.debugger.getThreads()));
    }

    public DebuggingView.DVSupport.STATE getState() {
        return this.debugger.isFinished() ? DebuggingView.DVSupport.STATE.DISCONNECTED : DebuggingView.DVSupport.STATE.RUNNING;
    }

    public List<DebuggingView.DVThread> getAllThreads() {
        return this.debugger.getThreads().getAll();
    }

    public DebuggingView.DVThread getCurrentThread() {
        return this.debugger.getCurrentThread();
    }

    public String getDisplayName(DebuggingView.DVThread thread) {
        return ((CPPThread)thread).getName();
    }

    public Image getIcon(DebuggingView.DVThread thread) {
        String iconPath = thread.isSuspended() ? THREAD_SUSPENDED_ICON : THREAD_RUNNING_ICON;
        return ImageUtilities.loadImage((String)iconPath);
    }

    public Session getSession() {
        return this.session;
    }

    public void resume() {
        this.session.getCurrentEngine().getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
    }

    public Set<DebuggingView.Deadlock> getDeadlocks() {
        return null;
    }

    protected List<DebuggingView.DVFilter> getFilters() {
        return Collections.emptyList();
    }

    @Override
    public void currentThread(CPPThread thread) {
        this.firePropertyChange("currentThread", null, thread);
    }

    @Override
    public void currentFrame(CPPFrame frame) {
    }

    @Override
    public void suspended(boolean suspended) {
    }

    @Override
    public void finished() {
    }

    @Override
    public void threadStarted(CPPThread thread) {
        this.firePropertyChange("threadStarted", null, thread);
    }

    @Override
    public void threadDied(CPPThread thread) {
        this.firePropertyChange("threadDied", thread, null);
    }

    public void doFirePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue);
    }
}

