/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class StackElement {
    public static final StackElement NULL = new StackElement(null, 0, 0, null, null, null);
    private int enterPosition;
    public final StackElement parent;
    public final int depth;
    public final int ruleId;
    public final String endRule;
    public final ScopeListElement nameScopesList;
    public final ScopeListElement contentNameScopesList;

    public StackElement(StackElement parent, int ruleId, int enterPos, String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        this.parent = parent;
        this.depth = this.parent != null ? this.parent.depth + 1 : 1;
        this.ruleId = ruleId;
        this.enterPosition = enterPos;
        this.endRule = endRule;
        this.nameScopesList = nameScopesList;
        this.contentNameScopesList = contentNameScopesList;
    }

    private static boolean structuralEquals(StackElement a, StackElement b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.depth == b.depth && a.ruleId == b.ruleId && !Objects.equals(a.endRule, b.endRule) && StackElement.structuralEquals(a.parent, b.parent);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof StackElement)) {
            return false;
        }
        StackElement stackElement = (StackElement)other;
        return StackElement.structuralEquals(this, stackElement) && this.contentNameScopesList.equals(stackElement.contentNameScopesList);
    }

    public int hashCode() {
        return Objects.hash(this.depth, this.ruleId, this.endRule, this.parent, this.contentNameScopesList);
    }

    public void reset() {
        StackElement el = this;
        while (el != null) {
            el.enterPosition = -1;
            el = el.parent;
        }
    }

    public StackElement pop() {
        return this.parent;
    }

    public StackElement safePop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public StackElement push(int ruleId, int enterPos, String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        return new StackElement(this, ruleId, enterPos, endRule, nameScopesList, contentNameScopesList);
    }

    public int getEnterPos() {
        return this.enterPosition;
    }

    public Rule getRule(IRuleRegistry grammar) {
        return grammar.getRule(this.ruleId);
    }

    private void appendString(List<String> res) {
        if (this.parent != null) {
            this.parent.appendString(res);
        }
        res.add('(' + Integer.toString(this.ruleId) + ')');
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>();
        this.appendString(r);
        return '[' + String.join((CharSequence)", ", r) + ']';
    }

    public StackElement setContentNameScopesList(ScopeListElement contentNameScopesList) {
        if (this.contentNameScopesList.equals(contentNameScopesList)) {
            return this;
        }
        return this.parent.push(this.ruleId, this.enterPosition, this.endRule, this.nameScopesList, contentNameScopesList);
    }

    public StackElement setEndRule(String endRule) {
        if (this.endRule != null && this.endRule.equals(endRule)) {
            return this;
        }
        return new StackElement(this.parent, this.ruleId, this.enterPosition, endRule, this.nameScopesList, this.contentNameScopesList);
    }

    public boolean hasSameRuleAs(StackElement other) {
        return this.ruleId == other.ruleId;
    }
}

