/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.ICompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class BeginWhileRule
extends Rule {
    private RegExpSource begin;
    public final List<CaptureRule> beginCaptures;
    public final List<CaptureRule> whileCaptures;
    private RegExpSource _while;
    public final boolean whileHasBackReferences;
    public final boolean hasMissingPatterns;
    public final Integer[] patterns;
    private RegExpSourceList cachedCompiledPatterns;
    private RegExpSourceList cachedCompiledWhilePatterns;

    public BeginWhileRule(int id, String name, String contentName, String begin, List<CaptureRule> beginCaptures, String _while, List<CaptureRule> whileCaptures, ICompilePatternsResult patterns) {
        super(id, name, contentName);
        this.begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.whileCaptures = whileCaptures;
        this._while = new RegExpSource(_while, -2);
        this.whileHasBackReferences = this._while.hasBackReferences();
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
        this.cachedCompiledPatterns = null;
        this.cachedCompiledWhilePatterns = null;
    }

    public String getWhileWithResolvedBackReferences(String lineText, IOnigCaptureIndex[] captureIndices) {
        return this._while.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        if (isFirst) {
            for (Integer pattern : this.patterns) {
                Rule rule = grammar.getRule(pattern);
                rule.collectPatternsRecursive(grammar, out, false);
            }
        } else {
            out.push(this.begin);
        }
    }

    @Override
    public ICompiledRule compile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        this.precompile(grammar);
        return this.cachedCompiledPatterns.compile(grammar, allowA, allowG);
    }

    private void precompile(IRuleRegistry grammar) {
        if (this.cachedCompiledPatterns == null) {
            this.cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, this.cachedCompiledPatterns, true);
        }
    }

    public ICompiledRule compileWhile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        this.precompileWhile();
        if (this._while.hasBackReferences()) {
            this.cachedCompiledWhilePatterns.setSource(0, endRegexSource);
        }
        return this.cachedCompiledWhilePatterns.compile(grammar, allowA, allowG);
    }

    private void precompileWhile() {
        if (this.cachedCompiledWhilePatterns == null) {
            this.cachedCompiledWhilePatterns = new RegExpSourceList();
            this.cachedCompiledWhilePatterns.push(this._while.hasBackReferences() ? this._while.clone() : this._while);
        }
    }
}

