/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.CommentHandler;
import org.netbeans.modules.css.lib.api.CssTokenId;

public class CssCommentHandler
extends CommentHandler.DefaultCommentHandler {
    private static final String COMMENT_START_DELIMITER = "/*";
    private static final String COMMENT_END_DELIMITER = "*/";

    public String getCommentStartDelimiter() {
        return COMMENT_START_DELIMITER;
    }

    public String getCommentEndDelimiter() {
        return COMMENT_END_DELIMITER;
    }

    private OffsetRange getCssAreaRange(Document doc, int from, int to) {
        TokenSequence<CssTokenId> ts = this.getCssTokenSequence(doc, from);
        if (ts == null) {
            return OffsetRange.NONE;
        }
        ts.moveStart();
        int limitedFrom = ts.moveNext() ? ts.offset() : from;
        ts.moveEnd();
        int limitedTo = ts.moveNext() ? ts.offset() + ts.token().length() : to;
        return new OffsetRange(limitedFrom, limitedTo);
    }

    public int[] getCommentBlocks(final Document doc, final int from, final int to) {
        final ArrayList comments = new ArrayList();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int nextCommentEnd;
                int nextCommentStart;
                int commentEndOffset;
                CharSequence text = DocumentUtilities.getText((Document)doc);
                int lastCommentStartIndex = CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)CssCommentHandler.this.getCommentStartDelimiter(), (int)from);
                int lastCommentEndIndex = from > 0 ? CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)CssCommentHandler.this.getCommentEndDelimiter(), (int)(from - 1)) : -1;
                OffsetRange range = CssCommentHandler.this.getCssAreaRange(doc, from, to);
                if (range != OffsetRange.NONE && lastCommentStartIndex < range.getStart()) {
                    lastCommentStartIndex = -1;
                }
                int searchFrom = from;
                if (lastCommentStartIndex > -1 && (lastCommentStartIndex > lastCommentEndIndex || lastCommentEndIndex == -1) && (commentEndOffset = CssCommentHandler.this.getCommentEnd(text, lastCommentStartIndex)) > 0) {
                    comments.add(lastCommentStartIndex);
                    comments.add(commentEndOffset);
                    searchFrom = commentEndOffset;
                }
                while ((nextCommentStart = CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)CssCommentHandler.this.getCommentStartDelimiter(), (int)searchFrom)) != -1 && nextCommentStart < to && (nextCommentEnd = CssCommentHandler.this.getCommentEnd(text, nextCommentStart)) > 0) {
                    comments.add(nextCommentStart);
                    comments.add(nextCommentEnd);
                    searchFrom = nextCommentEnd;
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(task);
        } else {
            task.run();
        }
        int[] arr = new int[comments.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Integer)comments.get(i);
        }
        return arr;
    }

    private int getCommentEnd(CharSequence text, int commentStartOffset) {
        int offset = CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)this.getCommentEndDelimiter(), (int)commentStartOffset);
        return offset == -1 ? -1 : offset + this.getCommentEndDelimiter().length();
    }

    private TokenSequence<CssTokenId> getCssTokenSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        while (ts.moveNext() || ts.movePrevious()) {
            if (ts.language() == CssTokenId.language()) {
                return ts;
            }
            if ((ts = ts.embedded()) == null) break;
            ts.move(offset);
        }
        return null;
    }
}

