/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.parsing.impl.indexing.LogContext;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.lucene.DocumentBasedIndexManager;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexFactory;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

public class IndexingModule {
    private static final String STOP_HOOKS_PATH = "Parsing/Indexing/Stop";
    private static volatile boolean closed;

    public static boolean isClosed() {
        return closed;
    }

    private static void callStopHooks() {
        for (Runnable r : Lookups.forPath((String)STOP_HOOKS_PATH).lookupAll(Runnable.class)) {
            try {
                r.run();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }

    public static class Shutdown
    implements Runnable,
    Callable<Boolean> {
        @Override
        public void run() {
            closed = true;
            Runnable postTask = new Runnable(){

                @Override
                public void run() {
                    IndexingModule.callStopHooks();
                    LuceneIndexFactory.getDefault().close();
                    DocumentBasedIndexManager.getDefault().close();
                }
            };
            try {
                RepositoryUpdater.getDefault().stop(postTask);
            }
            catch (IllegalStateException | TimeoutException e) {
                postTask.run();
            }
        }

        @Override
        public Boolean call() throws Exception {
            LogContext.notifyClosing();
            return true;
        }
    }

    public static class Startup
    implements Runnable {
        @Override
        public void run() {
            RepositoryUpdater.getDefault().start(false);
        }
    }
}

