/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.OneCheckboxCustomizer;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HideField
extends AbstractHint {
    static final String KEY_WARN_HIDDEN_STATIC_FIELDS = "warn-hidden-static-fields";
    private static final boolean DEFAULT_WARN_HIDDEN_STATIC_FIELDS = true;
    volatile transient boolean stop;
    private static final Object KEY_MEMBERS_CACHE = new Object();

    public HideField() {
        this("FieldNameHidesFieldInSuperclass");
    }

    public HideField(String ... sw) {
        super(true, false, AbstractHint.HintSeverity.WARNING, sw);
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.VARIABLE);
    }

    protected List<Fix> computeFixes(CompilationInfo compilationInfo, TreePath treePath, int[] bounds) {
        this.stop = false;
        Element el = compilationInfo.getTrees().getElement(treePath);
        if (el == null || el.getKind() != ElementKind.FIELD) {
            return null;
        }
        if (el.getSimpleName().contentEquals("<error>")) {
            return null;
        }
        Element hidden = null;
        TypeElement te = (TypeElement)el.getEnclosingElement();
        for (Element element : HideField.getAllMembers(compilationInfo, te)) {
            if (this.stop) {
                return null;
            }
            if (!compilationInfo.getElements().hides(el, element)) continue;
            hidden = element;
            break;
        }
        if (hidden == null) {
            return null;
        }
        if (!this.getPreferences(null).getBoolean(KEY_WARN_HIDDEN_STATIC_FIELDS, true) && hidden.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        int[] span = compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
        if (span == null) {
            return null;
        }
        List<Fix> list = Collections.singletonList(new FixImpl((span[1] + span[0]) / 2, compilationInfo.getFileObject(), false));
        bounds[0] = span[0];
        bounds[1] = span[1];
        return list;
    }

    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        int[] span = new int[2];
        List<Fix> fixes = this.computeFixes(compilationInfo, treePath, span);
        if (fixes == null) {
            return null;
        }
        ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), fixes, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
        return Collections.singletonList(ed);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_HiddenField");
    }

    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_HiddenField");
    }

    public void cancel() {
        this.stop = true;
    }

    public JComponent getCustomizer(Preferences node) {
        return new OneCheckboxCustomizer(node, NbBundle.getMessage(HideField.class, (String)"LBL_WarnHiddenStaticFields"), NbBundle.getMessage(HideField.class, (String)"TP_WarnHiddenStaticFields"), KEY_WARN_HIDDEN_STATIC_FIELDS, true);
    }

    protected static synchronized Iterable<? extends Element> getAllMembers(CompilationInfo info, TypeElement clazz) {
        List<? extends Element> members;
        HashMap<TypeElement, List<? extends Element>> map = (HashMap<TypeElement, List<? extends Element>>)info.getCachedValue(KEY_MEMBERS_CACHE);
        if (map == null) {
            map = new HashMap<TypeElement, List<? extends Element>>();
            info.putCachedValue(KEY_MEMBERS_CACHE, map, CompilationInfo.CacheClearPolicy.ON_SIGNATURE_CHANGE);
        }
        if ((members = (List<? extends Element>)map.get(clazz)) == null) {
            members = info.getElements().getAllMembers(clazz);
            map.put(clazz, members);
        }
        return members;
    }

    static class FixImpl
    implements Fix,
    Runnable {
        private final int caret;
        private final FileObject file;
        private final boolean hideFieldByVariable;

        public FixImpl(int caret, FileObject file, boolean hideFieldByVariable) {
            this.caret = caret;
            this.file = file;
            this.hideFieldByVariable = hideFieldByVariable;
        }

        public String getText() {
            return this.hideFieldByVariable ? NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixHiddenByVariableFiledText") : NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixHiddenFiledText");
        }

        public ChangeInfo implement() throws IOException {
            SwingUtilities.invokeLater(this);
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie cook = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                if (cook == null) {
                    return;
                }
                JEditorPane[] arr = cook.getOpenedPanes();
                if (arr == null) {
                    return;
                }
                arr[0].setCaretPosition(this.caret);
                InstantRenamePerformer.invokeInstantRename((JTextComponent)arr[0]);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String toString() {
            return "FixHideField";
        }

        public void cancel() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (this.caret != other.caret) {
                return false;
            }
            if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
                return false;
            }
            return this.hideFieldByVariable == other.hideFieldByVariable;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + this.caret;
            hash = 17 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 17 * hash + (this.hideFieldByVariable ? 1 : 0);
            return hash;
        }
    }
}

