/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ParamEncapsulation {
    private static final String COLLECTION = "java.util.Collection";
    private static final String MAP = "java.util.Map";
    private static final String DATE = "java.util.Date";
    private static final String CALENDAR = "java.util.Calendar";
    private static final String A_OBJ = "java.lang.Object[]";
    private static final String A_BOOL = "boolean[]";
    private static final String A_BYTE = "byte[]";
    private static final String A_CHAR = "char[]";
    private static final String A_SHORT = "short[]";
    private static final String A_INT = "int[]";
    private static final String A_LONG = "long[]";
    private static final String A_FLOAT = "float[]";
    private static final String A_DOUBLE = "double[]";

    public static ErrorDescription collection(HintContext ctx) {
        assert (ctx != null);
        return ParamEncapsulation.create(ctx, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToCollection"), "AssignmentToCollectionOrArrayFieldFromParameter");
    }

    public static ErrorDescription array(HintContext ctx) {
        assert (ctx != null);
        return ParamEncapsulation.create(ctx, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToArray"), "AssignmentToCollectionOrArrayFieldFromParameter");
    }

    public static ErrorDescription date(HintContext ctx) {
        assert (ctx != null);
        return ParamEncapsulation.create(ctx, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToDate"), "AssignmentToDateFieldFromParameter");
    }

    private static ErrorDescription create(HintContext ctx, String description, String suppressWarnings) {
        assert (ctx != null);
        TreePath varPath = (TreePath)ctx.getVariables().get("$var");
        assert (varPath != null);
        Trees trees = ctx.getInfo().getTrees();
        Element varElm = trees.getElement(varPath);
        if (varElm == null || varElm.getKind() != ElementKind.FIELD) {
            return null;
        }
        Element varOwner = varElm.getEnclosingElement();
        if (varOwner == null || !varOwner.getKind().isClass()) {
            return null;
        }
        TreePath exprPath = (TreePath)ctx.getVariables().get("$expr");
        Element exprElm = trees.getElement(exprPath);
        if (exprElm == null || exprElm.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        Element exprOwner = exprElm.getEnclosingElement();
        if (exprOwner == null || exprOwner.getKind() != ElementKind.METHOD || !((ExecutableElement)exprOwner).getParameters().contains(exprElm) || varOwner != exprOwner.getEnclosingElement()) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)varPath, (String)description, (Fix[])new Fix[0]);
    }
}

