/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ChangeType;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

final class ChangeTypeFix
extends JavaFix {
    private String treeName;
    private String type;
    private int position;

    public ChangeTypeFix(CompilationInfo info, TreePath path, String treeName, String type, int position) {
        super(info, path);
        this.treeName = ChangeTypeFix.escape(treeName);
        this.type = ChangeTypeFix.escape(type);
        this.position = position;
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy working = ctx.getWorkingCopy();
        TypeMirror[] tm = new TypeMirror[1];
        TypeMirror[] expressionType = new TypeMirror[1];
        Tree[] leaf = new Tree[1];
        ChangeType.computeType((CompilationInfo)working, this.position, tm, expressionType, leaf);
        expressionType[0] = Utilities.convertIfAnonymous(expressionType[0]);
        if (leaf[0] instanceof VariableTree) {
            VariableTree oldVariableTree = (VariableTree)leaf[0];
            TreeMaker make = working.getTreeMaker();
            VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), make.Type(expressionType[0]), oldVariableTree.getInitializer());
            working.rewrite(leaf[0], (Tree)newVariableTree);
        }
    }

    public String getText() {
        return NbBundle.getMessage(ChangeTypeFix.class, (String)"MSG_ChangeVariablesType", (Object)this.treeName, (Object)this.type);
    }

    static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }
}

