/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage.api;

import org.openide.filesystems.FileObject;

public class FileCoverageSummary
implements Comparable<FileCoverageSummary> {
    private final FileObject file;
    private final String displayName;
    private final int lineCount;
    private final int executedLineCount;
    private final int inferredCount;
    private final int partialCount;

    public FileCoverageSummary(FileObject file, String displayName, int lineCount, int executedLineCount, int inferredCount, int partialCount) {
        this.file = file;
        this.displayName = displayName;
        this.lineCount = lineCount;
        this.executedLineCount = executedLineCount;
        this.inferredCount = inferredCount;
        this.partialCount = partialCount;
    }

    public float getCoveragePercentage() {
        if (this.lineCount == 0) {
            return 0.0f;
        }
        return 100.0f * (float)this.executedLineCount / (float)this.lineCount;
    }

    @Override
    public int compareTo(FileCoverageSummary other) {
        float otherCov;
        float cov = this.getCoveragePercentage();
        if (cov == (otherCov = other.getCoveragePercentage())) {
            return 0;
        }
        return cov < otherCov ? -1 : 1;
    }

    public FileObject getFile() {
        return this.file;
    }

    public int getExecutedLineCount() {
        return this.executedLineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getInferredCount() {
        return this.inferredCount;
    }

    public int getPartialCount() {
        return this.partialCount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName + ": " + this.getCoveragePercentage() + "%";
    }
}

