/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.netbeans.modules.xml.xdm.visitor.HashNamespaceResolver;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.NodeList;

public class XPathFinder
extends ChildVisitor {
    private boolean done = false;
    private Node currentParent = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();
    private List<XPathSegment> tokens;
    private StringBuffer fixedUpXpath = new StringBuffer();
    public static final String SEP = "/";
    public static final String AT = "@";
    public static final String COLON = ":";
    public static final String BRACKET0 = "[";
    public static final String BRACKET1 = "]";
    public static final String XPNS = "xpns";
    private int countNamespaceSuffix = 0;

    public static String getXpath(Document root, Node target) {
        if (!(target instanceof Element) && !(target instanceof Attribute)) {
            throw new IllegalArgumentException("Can only get XPath expression for Element or Attribute");
        }
        List<Node> result = new PathFromRootVisitor().findPath(root, target);
        StringBuffer sb = new StringBuffer(128);
        Element parent = null;
        for (int j = result.size() - 1; j >= 0; --j) {
            Node n = result.get(j);
            boolean isElement = n instanceof Element;
            boolean isAttribute = n instanceof Attribute;
            if (!isElement && !isAttribute) continue;
            sb.append(SEP);
            int index = isElement ? XPathFinder.xpathIndexOf(parent, (Element)n) : -1;
            String prefix = n.getPrefix();
            String namespace = n.lookupNamespaceURI(prefix);
            if (isAttribute) {
                sb.append(AT);
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(':');
            }
            sb.append(n.getLocalName());
            if (isElement && index > 0) {
                sb.append(BRACKET0);
                sb.append(String.valueOf(index));
                sb.append(BRACKET1);
            }
            if (isAttribute) break;
            parent = (Element)n;
        }
        return sb.toString();
    }

    public Node findNode(Document root, String xpath) {
        List<Node> nodes = this.findNodes(root, xpath);
        return nodes.size() > 0 ? nodes.get(0) : null;
    }

    public List<Node> findNodes(Document root, String xpathExpression) {
        if (root == null || root.getDocumentElement() == null) {
            return Collections.emptyList();
        }
        this.init(root, xpathExpression);
        if (!this.isReadyForEvaluation()) {
            return new ArrayList<Node>();
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this.getNamespaceContext());
        NodeList result = null;
        try {
            result = (NodeList)xpath.evaluate(this.getFixedUpXpath(), root, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e.getCause().getLocalizedMessage());
        }
        assert (result != null);
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int i = 0; i < result.getLength(); ++i) {
            ret.add((Node)result.item(i));
        }
        return ret;
    }

    private static int xpathIndexOf(Node parentNode, Element child) {
        assert (child != null);
        if (!(parentNode instanceof Element) && !(parentNode instanceof Document)) {
            return -1;
        }
        NodeList children = parentNode.getChildNodes();
        int index = 0;
        String namespace = child.getNamespaceURI();
        String name = child.getLocalName();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element n = (Element)children.item(i);
            if (namespace != null && !namespace.equals(n.getNamespaceURI()) || namespace == null && n.getNamespaceURI() != null) continue;
            if (name.equals(n.getLocalName())) {
                ++index;
            }
            if (n.getId() != child.getId()) continue;
            return index;
        }
        return -1;
    }

    private void init(Document root, String xpath) {
        this.currentParent = root;
        this.initTokens(xpath);
        ((Element)root.getDocumentElement()).accept(this);
    }

    private void initTokens(String xpath) {
        this.tokens = new ArrayList<XPathSegment>();
        StringTokenizer tokenizer = new StringTokenizer(xpath, SEP);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            this.tokens.add(new XPathSegment(token));
        }
    }

    @Override
    protected void visitNode(Node e) {
        if (this.tokens.size() == 0) {
            this.done = true;
            return;
        }
        XPathSegment segment = this.tokens.get(0);
        if (!segment.checkTypeAndName(e, this.currentParent)) {
            return;
        }
        String currentNamespace = e.getNamespaceURI();
        if (currentNamespace != null) {
            String prefix = segment.getPrefix();
            if (prefix.length() > 0) {
                String namespace = e.lookupNamespaceURI(prefix);
                if (namespace == null) {
                    namespace = this.namespaces.get(prefix);
                }
                if (namespace != null && !currentNamespace.equals(namespace)) {
                    return;
                }
                segment.addToXpath(this.fixedUpXpath);
            } else {
                prefix = this.prefixes.get(currentNamespace);
                if (prefix == null) {
                    prefix = XPNS + String.valueOf(this.countNamespaceSuffix++);
                }
                segment.addToXpath(this.fixedUpXpath, prefix);
            }
            this.prefixes.put(currentNamespace, prefix);
            this.namespaces.put(prefix, currentNamespace);
        } else {
            segment.addToXpath(this.fixedUpXpath);
        }
        this.tokens.remove(0);
        this.currentParent = e;
        super.visitNode(e);
    }

    public boolean isReadyForEvaluation() {
        return this.done;
    }

    public NamespaceContext getNamespaceContext() {
        return new HashNamespaceResolver(this.namespaces, this.prefixes);
    }

    private String getFixedUpXpath() {
        return this.fixedUpXpath.toString();
    }

    private static class XPathSegment {
        private final String token;
        private String prefix;
        private String localPart;
        int index = -1;
        private String remaining;
        private boolean isAttribute;
        private boolean hasConditions;

        XPathSegment(String token) {
            this.token = token;
            this.parse();
        }

        private void parse() {
            StringTokenizer tokenizer = new StringTokenizer(this.token, ":[");
            ArrayList<String> parts = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String t = tokenizer.nextToken();
                parts.add(t);
            }
            if (parts.size() == 1) {
                this.prefix = "";
                this.localPart = (String)parts.get(0);
                this.remaining = "";
            } else if (parts.size() == 3) {
                this.prefix = (String)parts.get(0);
                this.localPart = (String)parts.get(1);
                this.remaining = (String)parts.get(2);
            } else if (parts.size() == 2) {
                String part0 = (String)parts.get(0);
                if (this.token.charAt(part0.length()) == ':') {
                    this.prefix = part0;
                    this.localPart = (String)parts.get(1);
                    this.remaining = "";
                } else {
                    this.localPart = (String)parts.get(0);
                    this.remaining = (String)parts.get(1);
                    this.prefix = "";
                }
            }
            if (this.prefix != null && this.prefix.startsWith(XPathFinder.AT)) {
                this.isAttribute = true;
                this.prefix = this.prefix.substring(1);
            } else if (this.localPart.startsWith(XPathFinder.AT)) {
                this.isAttribute = true;
                this.localPart = this.localPart.substring(1);
            }
            if (!this.remaining.equals("")) {
                String indexString = this.remaining.substring(0, this.remaining.length() - 1);
                try {
                    this.index = Integer.parseInt(indexString);
                }
                catch (NumberFormatException ex) {
                    this.hasConditions = true;
                }
                this.remaining = XPathFinder.BRACKET0 + this.remaining;
            }
        }

        public boolean checkTypeAndName(Node e, Node parent) {
            if (e instanceof Element) {
                if (this.isAttribute()) {
                    return false;
                }
                if (this.hasPlainIndex() && this.getIndex() != XPathFinder.xpathIndexOf(parent, (Element)e)) {
                    return false;
                }
            } else if (e instanceof Attribute) {
                if (!this.isAttribute()) {
                    return false;
                }
            } else {
                return false;
            }
            return e.getLocalName().equals(this.getLocalPart());
        }

        public void addToXpath(StringBuffer xpath, String prefix) {
            xpath.append(XPathFinder.SEP);
            if (this.isAttribute()) {
                xpath.append(XPathFinder.AT);
            }
            xpath.append(prefix);
            xpath.append(XPathFinder.COLON);
            xpath.append(this.localPart);
            if (this.hasConditions() && !prefix.startsWith(XPathFinder.XPNS)) {
                String prefixing = XPathFinder.AT + prefix + XPathFinder.COLON;
                xpath.append(this.remaining.replaceAll(XPathFinder.AT, prefixing));
            } else {
                xpath.append(this.remaining);
            }
        }

        public void addToXpath(StringBuffer xpath) {
            xpath.append(XPathFinder.SEP);
            xpath.append(this.token);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public boolean hasPlainIndex() {
            return this.index > -1;
        }

        public boolean hasConditions() {
            return this.hasConditions;
        }

        public int getIndex() {
            return this.index;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }

        public String toString() {
            return this.token;
        }
    }
}

