/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.features.ContextASTEvaluator;
import org.netbeans.modules.languages.features.UsagesASTEvaluator;

public class DeclarationASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<DeclarationASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<DeclarationASTEvaluator>>();
    private Document document;

    static void register(Document document) {
        if (DeclarationASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<DeclarationASTEvaluator>(new DeclarationASTEvaluator(document)));
    }

    static void unregister(Document document) {
        DeclarationASTEvaluator evaluator = DeclarationASTEvaluator.get(document);
        if (evaluator != null) {
            ParserManager.get(document).removeASTEvaluator(evaluator);
        }
        cache.remove(document);
    }

    static DeclarationASTEvaluator get(Document document) {
        WeakReference<DeclarationASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (DeclarationASTEvaluator)weakReference.get();
    }

    DeclarationASTEvaluator(Document document) {
        this.document = document;
        ParserManager.get(document).addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature feature) {
        SyntaxContext sc = SyntaxContext.create(this.document, ASTPath.create(path));
        if (!feature.getBoolean("condition", sc, true)) {
            return;
        }
        String name = ((String)feature.getValue("name", sc)).trim();
        String type = (String)feature.getValue("type", sc);
        if (name != null && name.length() > 0) {
            DatabaseDefinition original;
            String local = (String)feature.getValue("local", sc);
            ASTItem leaf = path.get(path.size() - 1);
            DatabaseContext context = ContextASTEvaluator.getCurrentContext(this.document, leaf.getOffset());
            if (local != null) {
                DatabaseContext c;
                for (c = context; c != null && !local.equals(c.getType()); c = c.getParent()) {
                }
                if (c != null) {
                    type = "local";
                }
            }
            DatabaseContext con = context;
            if ("method".equals(type) && (con = con.getParent()) == null) {
                con = context;
            }
            if ((original = con.getDefinition(name, leaf.getOffset())) != null) {
                original.addUsage(new DatabaseUsage(name, leaf.getOffset(), leaf.getEndOffset()));
            } else {
                DatabaseDefinition definition = new DatabaseDefinition(name, type, leaf.getOffset(), leaf.getEndOffset());
                con.addDefinition(definition);
                UsagesASTEvaluator.addDatabaseDefinition(this.document, definition);
            }
            ContextASTEvaluator.setEvaluated(this.document, true);
        }
    }

    @Override
    public String getFeatureName() {
        return "SEMANTIC_DECLARATION";
    }
}

