/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class JavaPlatformProblemProvider
implements ProjectProblemsProvider {
    private final ProjectProblemsProviderSupport support = new ProjectProblemsProviderSupport((Object)this);
    private final Project project;
    private final PropertyChangeListener pchListener;
    private final PropertyChangeListener pchJavaPlatformListener;
    private JavaPlatformManager platformManager;

    public JavaPlatformProblemProvider(Project project) {
        this.project = project;
        this.pchListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    JavaPlatformProblemProvider.this.support.fireProblemsChange();
                }
            }
        };
        this.pchJavaPlatformListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JavaPlatformProblemProvider.this.support.fireProblemsChange();
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        if (this.platformManager == null) {
            this.platformManager = JavaPlatformManager.getDefault();
            this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pchJavaPlatformListener, (Object)this.platformManager));
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watch.addPropertyChangeListener(this.pchListener);
        }
        return this.support.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                JavaPlatform plat;
                String[] desc;
                ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                String val = ((AuxiliaryProperties)JavaPlatformProblemProvider.this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
                if (val != null && (desc = (plat = BootClassPathImpl.getActivePlatform(val)) == null ? new String[]{Bundle.MGS_No_such_JDK(val), Bundle.DESC_No_such_JDK(val)} : (!plat.isValid() ? new String[]{Bundle.MGS_Broken_JDK(val), Bundle.DESC_Broken_JDK(val)} : null)) != null) {
                    toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)desc[0], (String)desc[1], (ProjectProblemResolver)new ProjectProblemResolver(){

                        public Future<ProjectProblemsProvider.Result> resolve() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PlatformsCustomizer.showCustomizer(null);
                                }
                            });
                            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
                        }
                    }));
                }
                return toRet;
            }
        });
    }

    private static final class Done
    implements Future<ProjectProblemsProvider.Result> {
        private final ProjectProblemsProvider.Result result;

        Done(@NonNull ProjectProblemsProvider.Result result) {
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

