/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.project.libraries.ui.Bundle;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.modules.project.libraries.ui.NewLibraryPanel;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class LibrariesCustomizer
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private static final Pattern VALID_LIBRARY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    private ExplorerManager manager;
    private LibrariesModel model;
    private BeanTreeView libraries;
    private LibraryStorageArea libraryStorageArea;
    private JButton createButton;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField libraryLocation;
    private JTextField libraryName;
    private JPanel libsPanel;
    private JTabbedPane properties;

    public LibrariesCustomizer(@NonNull LibraryStorageArea libraryStorageArea) {
        Parameters.notNull((CharSequence)"libraryStorageArea", (Object)libraryStorageArea);
        this.model = new LibrariesModel();
        this.libraryStorageArea = libraryStorageArea;
        this.initComponents();
        this.postInitComponents();
    }

    private void expandTree() {
        Node firstLibraryNode;
        LibrariesCustomizer.expandAllNodes(this.libraries, this.getExplorerManager().getRootContext());
        if (this.getExplorerManager().getSelectedNodes().length == 0 && (firstLibraryNode = LibrariesCustomizer.findFirstLibrary(this.getExplorerManager().getRootContext())) != null) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{firstLibraryNode});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private static Node findFirstLibrary(Node node) {
        Node[] subNodes;
        if (node == null) {
            return null;
        }
        if (node.getLookup().lookup(LibraryImplementation.class) != null) {
            return node;
        }
        for (Node subNode : subNodes = node.getChildren().getNodes(true)) {
            Node result = LibrariesCustomizer.findFirstLibrary(subNode);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setLibraryStorageArea(@NonNull LibraryStorageArea libraryStorageArea) {
        Parameters.notNull((CharSequence)"libraryStorageArea", (Object)libraryStorageArea);
        this.libraryStorageArea = libraryStorageArea;
        this.forceTreeRecreation();
        this.expandTree();
    }

    public LibrariesModel getModel() {
        return this.model;
    }

    public void hideLibrariesList() {
        this.libsPanel.setVisible(false);
        this.jLabel2.setVisible(false);
        this.createButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.jLabel3.setVisible(true);
        this.libraryLocation.setVisible(true);
    }

    public void forceTreeRecreation() {
        this.getExplorerManager().setRootContext(this.buildTree());
    }

    public void setSelectedLibrary(LibraryImplementation library) {
        if (library == null) {
            return;
        }
        ExplorerManager currentManager = this.getExplorerManager();
        Node root = currentManager.getRootContext();
        String[] path = new String[]{library.getType(), library.getName()};
        try {
            Node node = NodeOp.findPath((Node)root, (String[])path);
            if (node != null) {
                currentManager.setSelectedNodes(new Node[]{node});
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.project.libraries.ui.LibrariesCustomizer");
    }

    public boolean apply() {
        try {
            this.model.apply();
            return true;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.expandTree();
        this.libraries.requestFocus();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("selectedNodes".equals(event.getPropertyName())) {
                        Node[] nodes = (Node[])event.getNewValue();
                        LibrariesCustomizer.this.selectLibrary(nodes);
                        LibrariesCustomizer.this.libraries.requestFocus();
                    }
                }
            });
            this.manager.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                    Node[] nodes;
                    if ("selectedNodes".equals(event.getPropertyName()) && (nodes = (Node[])event.getNewValue()).length > 1) {
                        throw new PropertyVetoException("Invalid length", event);
                    }
                }
            });
            this.manager.setRootContext(this.buildTree());
        }
        return this.manager;
    }

    private void postInitComponents() {
        this.libraries = new LibrariesView();
        this.libsPanel.setLayout(new BorderLayout());
        this.libsPanel.add((Component)this.libraries);
        this.libraries.setPreferredSize(new Dimension(200, 334));
        this.libraryName.setColumns(25);
        this.libraryName.setEnabled(false);
        this.libraryName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibrariesCustomizer.this.nameChanged();
            }
        });
        this.libraryName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LibrariesCustomizer.this.nameChanged();
            }
        });
        this.jLabel3.setVisible(false);
        this.libraryLocation.setVisible(false);
        this.createButton.setEnabled(LibrariesSupport.getLibraryTypeProviders().length > 0);
    }

    private void nameChanged() {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length == 1) {
            LibraryImplementation lib = (LibraryImplementation)nodes[0].getLookup().lookup(LibraryImplementation.class);
            if (lib == null) {
                return;
            }
            String newName = this.libraryName.getText();
            if (newName.equals(LibrariesSupport.getLocalizedName((LibraryImplementation)lib))) {
                return;
            }
            if (newName.length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_InvalidName(), 0));
            } else if (LibrariesCustomizer.isExistingDisplayName(this.model, newName, this.model.getArea(lib))) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_ExistingName(newName), 0));
            } else {
                LibrariesSupport.setDisplayName((LibraryImplementation)lib, (String)newName);
            }
        }
    }

    private void selectLibrary(Node[] nodes) {
        LibraryCustomizerContextWrapper customizerContext;
        int tabCount = this.properties.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            this.properties.removeTabAt(0);
        }
        this.libraryName.setEnabled(false);
        this.libraryName.setText("");
        this.jLabel1.setVisible(false);
        this.libraryName.setVisible(false);
        this.properties.setVisible(false);
        this.deleteButton.setEnabled(false);
        if (nodes.length != 1) {
            return;
        }
        LibraryImplementation impl = (LibraryImplementation)nodes[0].getLookup().lookup(LibraryImplementation.class);
        if (impl == null) {
            return;
        }
        this.jLabel1.setVisible(true);
        this.libraryName.setVisible(true);
        this.properties.setVisible(true);
        boolean editable = this.model.isLibraryEditable(impl);
        this.libraryName.setEnabled(editable && LibrariesSupport.supportsDisplayName((LibraryImplementation)impl));
        this.deleteButton.setEnabled(editable);
        this.libraryName.setText(LibrariesSupport.getLocalizedName((LibraryImplementation)impl));
        LibraryTypeProvider provider = (LibraryTypeProvider)nodes[0].getLookup().lookup(LibraryTypeProvider.class);
        if (provider == null) {
            return;
        }
        LibraryStorageArea area = (LibraryStorageArea)nodes[0].getLookup().lookup(LibraryStorageArea.class);
        if (area != LibraryStorageArea.GLOBAL) {
            customizerContext = new LibraryCustomizerContextWrapper(impl, area);
            File f = Utilities.toFile((URI)URI.create(area.getLocation().toExternalForm()));
            this.libraryLocation.setText(f.getPath());
        } else {
            customizerContext = new LibraryCustomizerContextWrapper(impl, null);
            this.libraryLocation.setText(Bundle.LABEL_Global_Libraries());
        }
        String[] volumeTypes = provider.getSupportedVolumeTypes();
        for (int i = 0; i < volumeTypes.length; ++i) {
            Customizer c = provider.getCustomizer(volumeTypes[i]);
            if (!(c instanceof JComponent)) continue;
            c.setObject(customizerContext);
            JComponent component = (JComponent)((Object)c);
            component.setEnabled(editable);
            String tabName = component.getName();
            if (tabName == null) {
                tabName = volumeTypes[i];
            }
            this.properties.addTab(tabName, component);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryName = new JTextField();
        this.createButton = new JButton();
        this.deleteButton = new JButton();
        this.libsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.properties = new JTabbedPane();
        this.jLabel3 = new JLabel();
        this.libraryLocation = new JTextField();
        this.setMinimumSize(new Dimension(642, 395));
        this.jLabel1.setLabelFor(this.libraryName);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("CTL_CustomizerLibraryName"));
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)bundle.getString("CTL_NewLibrary"));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.createLibrary(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)bundle.getString("CTL_DeleteLibrary"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.deleteLibrary(evt);
            }
        });
        this.libsPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout libsPanelLayout = new GroupLayout(this.libsPanel);
        this.libsPanel.setLayout(libsPanelLayout);
        libsPanelLayout.setHorizontalGroup(libsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 190, Short.MAX_VALUE));
        libsPanelLayout.setVerticalGroup(libsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 382, Short.MAX_VALUE));
        this.jLabel2.setLabelFor(this.libsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("TXT_LibrariesPanel"));
        this.properties.setPreferredSize(new Dimension(400, 300));
        this.jLabel3.setLabelFor(this.libraryLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)bundle.getString("CTL_CustomizerLibraryLocationName"));
        this.libraryLocation.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.createButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addGroup(layout.createSequentialGroup().addComponent(this.libsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.libraryLocation, -1, 388, Short.MAX_VALUE).addComponent(this.libraryName, -1, 388, Short.MAX_VALUE))).addComponent(this.properties, -1, 503, Short.MAX_VALUE))).addComponent(this.jLabel2, -2, 186, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.libraryName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.libraryLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.properties, -1, 319, Short.MAX_VALUE)).addComponent(this.libsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createButton).addComponent(this.deleteButton))));
        this.libraryName.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_LibraryName"));
        this.createButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_NewLibrary"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_DeleteLibrary"));
        this.libsPanel.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_libsPanel"));
        this.properties.getAccessibleContext().setAccessibleName(bundle.getString("AN_LibrariesCustomizerProperties"));
        this.properties.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_LibrariesCustomizerProperties"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription("Edit Library");
        this.libraryLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_LibraryLocation"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_LibrariesCustomizer"));
    }

    private void deleteLibrary(ActionEvent evt) {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length == 1) {
            LibraryImplementation library = (LibraryImplementation)nodes[0].getLookup().lookup(LibraryImplementation.class);
            if (library == null) {
                return;
            }
            Node[] sib = nodes[0].getParentNode().getChildren().getNodes(true);
            Node selNode = null;
            for (int i = 0; i < sib.length; ++i) {
                if (!nodes[0].equals((Object)sib[i])) continue;
                if (i > 0) {
                    selNode = sib[i - 1];
                    continue;
                }
                if (i >= sib.length - 1) continue;
                selNode = sib[i + 1];
            }
            this.model.removeLibrary(library);
            try {
                if (selNode != null) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{selNode});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.libraries.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLibrary(ActionEvent evt) {
        block15: {
            Window dlg = null;
            try {
                String preselectedLibraryType = null;
                LibraryStorageArea area = null;
                Node[] preselectedNodes = this.getExplorerManager().getSelectedNodes();
                if (preselectedNodes.length == 1) {
                    LibraryTypeProvider provider = (LibraryTypeProvider)preselectedNodes[0].getLookup().lookup(LibraryTypeProvider.class);
                    if (provider != null) {
                        preselectedLibraryType = provider.getLibraryType();
                    }
                    area = (LibraryStorageArea)preselectedNodes[0].getLookup().lookup(LibraryStorageArea.class);
                }
                NewLibraryPanel p = new NewLibraryPanel(this.model, preselectedLibraryType, area);
                DialogDescriptor dd = new DialogDescriptor((Object)p, Bundle.CTL_CreateLibrary(), true, 2, null, null);
                p.setDialogDescriptor(dd);
                dlg = DialogDisplayer.getDefault().createDialog(dd);
                ((Dialog)dlg).setVisible(true);
                if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                    LibraryImplementation impl;
                    String libraryType = p.getLibraryType();
                    String currentLibraryName = p.getLibraryName();
                    String antLibraryName = LibrariesCustomizer.createFreeAntLibraryName(currentLibraryName, this.model, area);
                    if (area != LibraryStorageArea.GLOBAL) {
                        impl = this.model.createArealLibrary(libraryType, currentLibraryName, area);
                    } else {
                        LibraryTypeProvider provider = LibrariesSupport.getLibraryTypeProvider((String)libraryType);
                        if (provider == null) {
                            return;
                        }
                        impl = provider.createLibrary();
                        impl.setName(antLibraryName);
                    }
                    LibrariesSupport.setDisplayName((LibraryImplementation)impl, (String)currentLibraryName);
                    this.model.addLibrary(impl);
                    this.forceTreeRecreation();
                    String[] path = new String[]{impl.getType(), impl.getName()};
                    ExplorerManager mgr = this.getExplorerManager();
                    try {
                        Node node = NodeOp.findPath((Node)mgr.getRootContext(), (String[])path);
                        if (node != null) {
                            mgr.setSelectedNodes(new Node[]{node});
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                    this.libraryName.requestFocus();
                    this.libraryName.selectAll();
                    break block15;
                }
                this.libraries.requestFocus();
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    static boolean isExistingDisplayName(@NonNull LibrariesModel model, @NonNull String name, @NullAllowed LibraryStorageArea area) {
        for (LibraryImplementation libraryImplementation : model.getLibraries()) {
            if (!LibrariesSupport.getLocalizedName((LibraryImplementation)libraryImplementation).equals(name) || !Utilities.compareObjects((Object)model.getArea(libraryImplementation), (Object)area)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidName(@NonNull LibrariesModel model, @NonNull String name, @NullAllowed LibraryStorageArea area) {
        for (LibraryImplementation libraryImplementation : model.getLibraries()) {
            if (!libraryImplementation.getName().equals(name) || !Utilities.compareObjects((Object)model.getArea(libraryImplementation), (Object)area)) continue;
            return false;
        }
        return true;
    }

    public static String createFreeAntLibraryName(@NonNull String name, @NonNull LibrariesModel model, @NullAllowed LibraryStorageArea area) {
        int i;
        if (!VALID_LIBRARY_NAME.matcher(name).matches()) {
            StringBuilder sb = new StringBuilder(name);
            for (i = 0; i < sb.length(); ++i) {
                if (VALID_LIBRARY_NAME.matcher(sb.substring(i, i + 1)).matches()) continue;
                sb.replace(i, i + 1, "_");
            }
            name = sb.toString();
        }
        String uniqueName = name;
        i = 2;
        while (!LibrariesCustomizer.isValidName(model, uniqueName, area)) {
            uniqueName = String.format("%s_%d", name, i);
            ++i;
        }
        return uniqueName;
    }

    private static void expandAllNodes(BeanTreeView btv, Node node) {
        btv.expandNode(node);
        Children ch = node.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            LibrariesCustomizer.expandAllNodes(btv, nodes[i]);
        }
    }

    private Node buildTree() {
        return new AbstractNode((Children)new TypeChildren(this.libraryStorageArea));
    }

    private static class LibraryCustomizerContextWrapper
    extends LibraryCustomizerContext
    implements LibraryImplementation {
        LibraryCustomizerContextWrapper(LibraryImplementation lib, LibraryStorageArea area) {
            super(lib, area);
        }

        public String getType() {
            return this.getLibraryImplementation().getType();
        }

        public String getName() {
            return this.getLibraryImplementation().getName();
        }

        public String getDescription() {
            return this.getLibraryImplementation().getDescription();
        }

        public String getLocalizingBundle() {
            return this.getLibraryImplementation().getLocalizingBundle();
        }

        public List<URL> getContent(String volumeType) throws IllegalArgumentException {
            return this.getLibraryImplementation().getContent(volumeType);
        }

        public void setName(String name) {
            this.getLibraryImplementation().setName(name);
        }

        public void setDescription(String text) {
            this.getLibraryImplementation().setDescription(text);
        }

        public void setLocalizingBundle(String resourceName) {
            this.getLibraryImplementation().setLocalizingBundle(resourceName);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getLibraryImplementation().addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.getLibraryImplementation().removePropertyChangeListener(l);
        }

        public void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
            this.getLibraryImplementation().setContent(volumeType, path);
        }
    }

    private static class LibraryNode
    extends AbstractNode
    implements PropertyChangeListener {
        private static final String ICON = "org/netbeans/modules/project/libraries/resources/libraries.gif";
        private LibraryImplementation lib;

        LibraryNode(LibraryImplementation lib, LibraryTypeProvider provider, LibraryStorageArea area) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{lib, provider, area}));
            this.lib = lib;
            this.setIconBaseWithExtension(ICON);
            this.lib.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public String getName() {
            return this.lib.getName();
        }

        public String getDisplayName() {
            return LibrariesSupport.getLocalizedName((LibraryImplementation)this.lib);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.fireDisplayNameChange(null, null);
        }
    }

    private class CategoryChildren
    extends Children.Keys<LibraryImplementation>
    implements ChangeListener {
        private LibraryTypeProvider provider;
        private final LibraryStorageArea area;

        CategoryChildren(LibraryTypeProvider provider, LibraryStorageArea area) {
            this.provider = provider;
            this.area = area;
            LibrariesCustomizer.this.model.addChangeListener(this);
        }

        public void addNotify() {
            ArrayList<LibraryImplementation> keys = new ArrayList<LibraryImplementation>();
            for (LibraryImplementation libraryImplementation : LibrariesCustomizer.this.model.getLibraries()) {
                if (!this.provider.getLibraryType().equals(libraryImplementation.getType()) || !LibrariesCustomizer.this.model.getArea(libraryImplementation).equals(this.area)) continue;
                keys.add(libraryImplementation);
            }
            this.setKeys(keys);
        }

        public void removeNotify() {
            this.setKeys(new LibraryImplementation[0]);
        }

        protected Node[] createNodes(LibraryImplementation impl) {
            return new Node[]{new LibraryNode(impl, this.provider, this.area)};
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CategoryChildren.this.addNotify();
                }
            });
        }
    }

    private class CategoryNode
    extends AbstractNode {
        private LibraryTypeProvider provider;
        private Node iconDelegate;

        @SuppressWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_NEEDS_THIS"})
        CategoryNode(LibraryTypeProvider provider, LibraryStorageArea area) {
            super((Children)new CategoryChildren(provider, area), Lookups.fixed((Object[])new Object[]{provider, area}));
            this.provider = provider;
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.provider.getLibraryType();
        }

        public String getDisplayName() {
            return this.provider.getDisplayName();
        }

        public Image getIcon(int type) {
            return this.iconDelegate.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.iconDelegate.getOpenedIcon(type);
        }
    }

    private class TypeChildren
    extends Children.Keys<LibraryTypeProvider> {
        private final LibraryStorageArea area;

        TypeChildren(LibraryStorageArea area) {
            this.area = area;
        }

        public void addNotify() {
            this.setKeys(LibrariesSupport.getLibraryTypeProviders());
        }

        public void removeNotify() {
            this.setKeys(new LibraryTypeProvider[0]);
        }

        protected Node[] createNodes(LibraryTypeProvider provider) {
            return new Node[]{new CategoryNode(provider, this.area)};
        }
    }

    private static class LibrariesView
    extends BeanTreeView {
        LibrariesView() {
            this.setRootVisible(false);
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
            this.getAccessibleContext().setAccessibleDescription(Bundle.AD_Libraries());
        }
    }
}

