/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.api.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.api.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.api.customization.model.JavaPackage;
import org.netbeans.modules.websvc.customization.multiview.JavaUtilities;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class DefinitionsPanel
extends SaveableSectionInnerPanel {
    private Definitions definitions;
    private WSDLModel model;
    private Node node;
    private boolean wsdlDirty;
    private DefinitionsActionListener listener;
    private DefaultItemListener defaultListener;
    private JCheckBox defaultPackageCB;
    private ButtonGroup eamButtonGroup;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableMIMEContentCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel packageLabel;
    private JTextField packageNameText;

    public DefinitionsPanel(SectionView view, Definitions definitions, Node node) {
        super(view);
        this.definitions = definitions;
        this.model = this.definitions.getModel();
        this.node = node;
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.enableMIMEContentCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_MIME"));
        this.packageNameText.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_PACKAGE"));
        this.wsdlDirty = false;
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultPackageCB);
        this.defaultPackageCB.addItemListener(itemListener);
        this.addValidatee(this.packageNameText);
        this.listener = new DefinitionsActionListener();
        this.addModifier(this.packageNameText);
        this.addModifier(this.defaultPackageCB);
        ActionListener eamListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableAsyncMappingCB);
        this.enableAsyncMappingCB.addActionListener(eamListener);
        ActionListener emcListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(emcListener);
        ActionListener ewsListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableWrapperStyleCB);
        this.enableWrapperStyleCB.addActionListener(ewsListener);
    }

    private void sync() {
        List ee = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (ee.size() == 1) {
            DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
            EnableAsyncMapping eam = dc.getEnableAsyncMapping();
            if (eam != null) {
                this.setEnableAsyncMapping(eam.isEnabled());
            } else {
                this.setEnableAsyncMapping(false);
            }
            EnableWrapperStyle ews = dc.getEnableWrapperStyle();
            if (ews != null) {
                this.setEnableWrapperStyle(ews.isEnabled());
            } else {
                this.setEnableWrapperStyle(true);
            }
            EnableMIMEContent emc = dc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(false);
            }
            JavaPackage javaPackage = dc.getPackage();
            if (javaPackage != null) {
                this.setPackageName(javaPackage.getName());
            } else {
                this.setPackageName(null);
            }
        } else {
            this.setEnableAsyncMapping(false);
            this.setEnableWrapperStyle(true);
            this.setEnableMIMEContent(false);
            this.setPackageName(null);
        }
    }

    public void setEnableAsyncMapping(boolean enable) {
        this.enableAsyncMappingCB.setSelected(enable);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean enable) {
        this.enableWrapperStyleCB.setSelected(enable);
    }

    public boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public void setPackageName(String name) {
        if (name == null) {
            this.packageNameText.setText("");
            this.defaultPackageCB.setSelected(true);
            this.packageNameText.setEnabled(false);
        } else {
            this.packageNameText.setEnabled(true);
            this.packageNameText.setText(name);
            this.defaultPackageCB.setSelected(false);
        }
    }

    public String getPackageName() {
        if (this.defaultPackageCB.isSelected()) {
            return null;
        }
        String packageName = this.packageNameText.getText().trim();
        if (packageName.length() > 0) {
            return packageName;
        }
        return null;
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block53: {
            List ee = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
            CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
            try {
                if (jComponent == this.packageNameText || jComponent == this.defaultPackageCB) {
                    if (this.getPackageName() == null) {
                        DefinitionsCustomization dc;
                        JavaPackage javaPackage;
                        if (ee.size() != 1 || (javaPackage = (dc = (DefinitionsCustomization)ee.get(0)).getPackage()) == null) break block53;
                        try {
                            this.model.startTransaction();
                            dc.removePackage(javaPackage);
                            this.wsdlDirty = true;
                            break block53;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    if (ee.size() == 1) {
                        DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                        JavaPackage javaPackage = dc.getPackage();
                        if (javaPackage == null) {
                            try {
                                this.model.startTransaction();
                                javaPackage = factory.createJavaPackage(this.model);
                                javaPackage.setName(this.packageNameText.getText());
                                dc.setPackage(javaPackage);
                                this.wsdlDirty = true;
                                break block53;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            javaPackage.setName(this.packageNameText.getText());
                            this.wsdlDirty = true;
                            break block53;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                    JavaPackage javaPackage = factory.createJavaPackage(this.model);
                    try {
                        this.model.startTransaction();
                        javaPackage.setName(this.packageNameText.getText());
                        dc.setPackage(javaPackage);
                        this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                        this.wsdlDirty = true;
                        break block53;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent == this.enableWrapperStyleCB) {
                    if (ee.size() == 1) {
                        DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                        EnableWrapperStyle ews = dc.getEnableWrapperStyle();
                        if (ews == null) {
                            try {
                                this.model.startTransaction();
                                ews = factory.createEnableWrapperStyle(this.model);
                                ews.setEnabled(this.getEnableWrapperStyle());
                                dc.setEnableWrapperStyle(ews);
                                this.wsdlDirty = true;
                                break block53;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            ews.setEnabled(this.getEnableWrapperStyle());
                            this.wsdlDirty = true;
                            break block53;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                    EnableWrapperStyle ews = factory.createEnableWrapperStyle(this.model);
                    try {
                        this.model.startTransaction();
                        ews.setEnabled(this.getEnableWrapperStyle());
                        dc.setEnableWrapperStyle(ews);
                        this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                        this.wsdlDirty = true;
                        break block53;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent == this.enableAsyncMappingCB) {
                    if (ee.size() == 1) {
                        DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                        EnableAsyncMapping eam = dc.getEnableAsyncMapping();
                        if (eam == null) {
                            try {
                                this.model.startTransaction();
                                eam = factory.createEnableAsyncMapping(this.model);
                                eam.setEnabled(this.getEnableAsyncMapping());
                                dc.setEnableAsyncMapping(eam);
                                this.wsdlDirty = true;
                                break block53;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            eam.setEnabled(this.getEnableAsyncMapping());
                            this.wsdlDirty = true;
                            break block53;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                    EnableAsyncMapping eam = factory.createEnableAsyncMapping(this.model);
                    try {
                        this.model.startTransaction();
                        eam.setEnabled(this.getEnableAsyncMapping());
                        dc.setEnableAsyncMapping(eam);
                        this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                        this.wsdlDirty = true;
                        break block53;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent != this.enableMIMEContentCB) break block53;
                if (ee.size() == 1) {
                    DefinitionsCustomization dc = (DefinitionsCustomization)ee.get(0);
                    EnableMIMEContent emc = dc.getEnableMIMEContent();
                    if (emc == null) {
                        try {
                            this.model.startTransaction();
                            emc = factory.createEnableMIMEContent(this.model);
                            emc.setEnabled(this.getEnableMIMEContent());
                            dc.setEnableMIMEContent(emc);
                            this.wsdlDirty = true;
                            break block53;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                        break block53;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                DefinitionsCustomization dc = factory.createDefinitionsCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent());
                    dc.setEnableMIMEContent(emc);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)dc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.packageNameText && !JavaUtilities.isValidPackageName(val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.emcButtonGroup = new ButtonGroup();
        this.packageLabel = new JLabel();
        this.packageNameText = new JTextField();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        this.enableMIMEContentCB = new JCheckBox();
        this.defaultPackageCB = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.packageLabel.setText(bundle.getString("LBL_PACKAGE_NAME"));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setActionCommand(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setActionCommand(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.defaultPackageCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultPackageCB.setText(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultPackageCB.setContentAreaFilled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.packageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.packageNameText, -2, 173, -2).addGap(26, 26, 26).addComponent(this.defaultPackageCB)).addComponent(this.enableWrapperStyleCB).addComponent(this.enableMIMEContentCB).addComponent(this.enableAsyncMappingCB)).addContainerGap(80, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageLabel).addComponent(this.defaultPackageCB).addComponent(this.packageNameText, -2, 25, -2)).addGap(20, 20, 20).addComponent(this.enableWrapperStyleCB).addGap(19, 19, 19).addComponent(this.enableMIMEContentCB).addGap(19, 19, 19).addComponent(this.enableAsyncMappingCB).addContainerGap(18, Short.MAX_VALUE)));
        this.packageLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_PACKAGE_NAME"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.defaultPackageCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_DEFAULT"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DefinitionsPanel.this.defaultPackageCB.isSelected()) {
                DefinitionsPanel.this.packageNameText.setEnabled(false);
            } else {
                DefinitionsPanel.this.packageNameText.setEnabled(true);
                DefinitionsPanel.this.packageNameText.requestFocus();
            }
        }
    }

    class DefinitionsActionListener
    implements ActionListener {
        DefinitionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefinitionsPanel.this.setValue((JComponent)e.getSource(), null);
        }
    }
}

