/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;

public abstract class AbstractUnicodeClassCharacter
extends AbstractDatatype {
    private static final int SURROGATE_OFFSET = -56613888;

    protected abstract UnicodeSet getUnicodeSet();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        switch (literal.length()) {
            case 0: {
                throw this.newDatatypeException("The empty string is not a " + this.getName() + ".");
            }
            case 1: {
                char c = literal.charAt(0);
                if (!this.getUnicodeSet().contains((int)c)) {
                    throw this.newDatatypeException(0, "The character ", c, " is not a " + this.getName() + ".");
                }
                return;
            }
            case 2: {
                char hi = literal.charAt(0);
                char lo = literal.charAt(1);
                if ((lo & 0xFC00) != 56320 || (hi & 0xFC00) != 55296) break;
                int codepoint = (hi << 10) + lo + -56613888;
                if (!this.getUnicodeSet().contains(codepoint)) {
                    throw this.newDatatypeException(0, "The character ", "" + hi + lo, " is not a " + this.getName() + ".");
                }
                return;
            }
        }
        throw this.newDatatypeException("A " + this.getName() + " must be a single character.");
    }

    @Override
    public DatatypeStreamingValidator createStreamingValidator(ValidationContext context) {
        return new DatatypeStreamingValidator(){
            int codepoint = -2;

            private void addCharacter(char c) {
                if (this.codepoint == -1) {
                    return;
                }
                this.codepoint = (this.codepoint & 0xFC00) == 55296 ? ((c & 0xFC00) == 56320 ? (this.codepoint << 10) + c + -56613888 : -1) : (this.codepoint == -2 ? (int)c : -1);
            }

            public void addCharacters(char[] buf, int start, int len) {
                if (this.codepoint == -1) {
                    return;
                }
                for (int i = start; i < start + len; ++i) {
                    this.addCharacter(buf[i]);
                }
            }

            public void checkValid() throws DatatypeException {
                if (this.codepoint == -2) {
                    throw AbstractUnicodeClassCharacter.this.newDatatypeException("The empty string is not a " + AbstractUnicodeClassCharacter.this.getName() + ".");
                }
                if (this.codepoint == -1) {
                    throw AbstractUnicodeClassCharacter.this.newDatatypeException("A " + AbstractUnicodeClassCharacter.this.getName() + " must be a single character.");
                }
                if (!AbstractUnicodeClassCharacter.this.getUnicodeSet().contains(this.codepoint)) {
                    throw AbstractUnicodeClassCharacter.this.newDatatypeException(0, "The character ", UCharacter.toString((int)this.codepoint), " is not a " + AbstractUnicodeClassCharacter.this.getName() + ".");
                }
            }

            public boolean isValid() {
                try {
                    this.checkValid();
                    return true;
                }
                catch (DatatypeException e) {
                    return false;
                }
            }
        };
    }
}

