/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.javascript2.extjs.ExtJsDataItem;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataLoader
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(DataLoader.class.getName());
    private static Map<String, Collection<ExtJsDataItem>> result = new HashMap<String, Collection<ExtJsDataItem>>();
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private String objectName;
    private String name;
    private String type;
    private String documentation;
    private String template;
    private List<ExtJsDataItem> items;
    private Tag inTag = Tag.notinterested;

    public static Map<String, Collection<ExtJsDataItem>> getData(File file) {
        result.clear();
        try {
            long start = System.currentTimeMillis();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            DataLoader handler = new DataLoader();
            parser.parse(file, (DefaultHandler)handler);
            long end = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "Loading data from file took {0}ms ", end - start);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(Tag.object.name())) {
            this.objectName = attributes.getValue(NAME);
            this.items = new ArrayList<ExtJsDataItem>();
        } else if (qName.equals(Tag.property.name())) {
            this.name = attributes.getValue(NAME);
            this.type = attributes.getValue(TYPE);
            this.documentation = "";
            this.template = "";
        }
        try {
            this.inTag = Tag.valueOf(qName);
        }
        catch (IllegalArgumentException iae) {
            this.inTag = Tag.notinterested;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(Tag.object.name())) {
            result.put(this.objectName, this.items);
        } else if (qName.equals(Tag.property.name())) {
            this.items.add(new ExtJsDataItem(this.name, this.type, this.documentation, this.template));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.inTag) {
            case doc: {
                this.documentation = this.documentation + new String(ch, start, length);
                break;
            }
            case template: {
                this.template = this.template + new String(ch, start, length);
                break;
            }
        }
    }

    private static enum Tag {
        object,
        property,
        doc,
        template,
        notinterested;

    }
}

