/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.connector.URLConnector;
import org.netbeans.installer.downloader.dispatcher.Process;
import org.netbeans.installer.downloader.impl.ChannelUtil;
import org.netbeans.installer.downloader.impl.PumpingImpl;
import org.netbeans.installer.downloader.impl.SectionImpl;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.StreamUtils;

public class Pump
implements Process {
    final PumpingImpl pumping;
    URLConnector connector = URLConnector.getConnector();
    InputStream in;
    OutputStream out;
    private static final int ATTEMPT_TIME_DELAY = 1000;
    private static final int MAX_ATTEMPT_COUNT = 3;

    public Pump(Pumping pumping) {
        this.pumping = (PumpingImpl)pumping;
    }

    public PumpingImpl pumping() {
        return this.pumping;
    }

    @Override
    public void init() {
    }

    @Override
    public void run() {
        if (!this.initPumping()) {
            return;
        }
        this.pumping.fireChanges("pumpingUpdate");
        if (!this.processPumping()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initPumping() {
        int attemptCount = 0;
        while (attemptCount < 3) {
            this.pumping.changeState(Pumping.State.CONNECTING);
            try {
                URL url = this.pumping.declaredURL();
                URLConnection connection = this.connector.establishConnection(url);
                this.in = connection.getInputStream();
                if (this.exitOnInterrupt()) {
                    boolean bl = false;
                    return bl;
                }
                this.initPumping(connection);
                this.pumping.changeState(Pumping.State.WAITING);
                boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                LogManager.log(ex);
                ++attemptCount;
                try {
                    this.pumping.changeState(Pumping.State.WAITING);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exit) {
                    this.pumping.changeState(Pumping.State.INTERRUPTED);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                try {
                    if (this.in == null) continue;
                    this.in.close();
                }
                catch (IOException ignored) {
                    LogManager.log(ignored);
                }
            }
        }
        this.pumping.changeState(Pumping.State.FAILED);
        return false;
    }

    private void initPumping(URLConnection connection) throws IOException {
        Date lastModif = new Date(connection.getLastModified());
        URL realUrl = connection.getURL();
        String accept = connection.getHeaderField("Accept-Ranges");
        boolean acceptBytes = accept != null ? accept.contains("bytes") : false;
        long length = connection.getContentLength();
        this.pumping.init(realUrl, length, lastModif, acceptBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPumping() {
        int attemptCount = 0;
        while (attemptCount < 3) {
            this.pumping.changeState(Pumping.State.CONNECTING);
            try {
                SectionImpl section = this.pumping.getSection();
                URL connectingUrl = this.pumping.realURL();
                URLConnection connection = this.connector.establishConnection(connectingUrl, section.headers());
                this.in = connection.getInputStream();
                if (this.exitOnInterrupt()) {
                    boolean bl = false;
                    return bl;
                }
                this.out = ChannelUtil.channelFragmentAsStream(this.pumping.outputFile(), section);
                this.pumping.changeState(Pumping.State.PUMPING);
                StreamUtils.transferData(this.in, this.out);
                if (section.length() > 0L && section.offset() != section.start() + section.length()) {
                    ++attemptCount;
                    continue;
                }
                this.pumping.changeState(Pumping.State.FINISHED);
                boolean ignored = true;
                return ignored;
            }
            catch (IOException ex) {
                LogManager.log(ex);
                if (this.exitOnInterrupt()) {
                    boolean connectingUrl = false;
                    return connectingUrl;
                }
                ++attemptCount;
                try {
                    this.pumping.changeState(Pumping.State.WAITING);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exit) {
                    this.pumping.changeState(Pumping.State.INTERRUPTED);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException ignored) {
                        LogManager.log(ignored);
                    }
                }
                if (this.out == null) continue;
                try {
                    this.out.close();
                }
                catch (IOException ignored) {
                    LogManager.log(ignored);
                }
            }
        }
        this.pumping.changeState(Pumping.State.FAILED);
        return false;
    }

    private boolean exitOnInterrupt() {
        if (!Thread.interrupted()) {
            return false;
        }
        this.pumping.changeState(Pumping.State.INTERRUPTED);
        return true;
    }

    @Override
    public void terminate() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ignored) {
                LogManager.log(ignored);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ignored) {
                LogManager.log(ignored);
            }
        }
    }
}

