/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.io.File;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public class RecordOption
extends CLIOptionOneArgument {
    public static final String RECORD_ARG = "--record";
    private static final String WARNING_TARGET_STATE_FILE_EXISTS_KEY = "O.warning.target.state.file.exists";
    private static final String WARNING_BAD_TARGET_STATE_FILE_ARG_KEY = "O.warning.bad.target.state.file.arg";

    @Override
    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        File stateFile = new File(arguments.next()).getAbsoluteFile();
        if (stateFile.exists()) {
            throw new CLIOptionException(ResourceUtils.getString(RecordOption.class, WARNING_TARGET_STATE_FILE_EXISTS_KEY, RECORD_ARG, stateFile));
        }
        System.setProperty("nbi.product.target.state.file.path", stateFile.getAbsolutePath());
    }

    @Override
    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(RecordOption.class, WARNING_BAD_TARGET_STATE_FILE_ARG_KEY, RECORD_ARG);
    }

    @Override
    public String getName() {
        return RECORD_ARG;
    }
}

