/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.nette2.ui.options.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class Nette2OptionsPanel
extends JPanel {
    private static final String NETTE_DIRECTORY_SUFFIX = ".nette-directory";
    private static final String NETTE_SANDBOX_SUFFIX = ".nette-sandbox";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseNetteButton;
    private JButton browseSandboxButton;
    private JLabel errorLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel netteLabel;
    private JTextField netteTextField;
    private JLabel sandboxLabel;
    private JTextField sandboxTextField;

    public Nette2OptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initListeners();
    }

    private void initListeners() {
        this.netteTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                Nette2OptionsPanel.this.fireChange();
            }
        });
        this.sandboxTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                Nette2OptionsPanel.this.fireChange();
            }
        });
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    public String getSandbox() {
        return this.sandboxTextField.getText();
    }

    public void setSandbox(String sandbox) {
        this.sandboxTextField.setText(sandbox);
    }

    public String getNetteDirectory() {
        return this.netteTextField.getText();
    }

    public void setNetteDirectory(String netteDirectory) {
        this.netteTextField.setText(netteDirectory);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.errorLabel = new JLabel();
        this.netteLabel = new JLabel();
        this.netteTextField = new JTextField();
        this.browseNetteButton = new JButton();
        this.jLabel1 = new JLabel();
        this.sandboxLabel = new JLabel();
        this.sandboxTextField = new JTextField();
        this.browseSandboxButton = new JButton();
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.jButton1.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.errorLabel.text"));
        this.netteLabel.setDisplayedMnemonic('n');
        this.netteLabel.setLabelFor(this.netteTextField);
        Mnemonics.setLocalizedText((JLabel)this.netteLabel, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.netteLabel.text"));
        this.netteTextField.setText(NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.netteTextField.text"));
        this.browseNetteButton.setMnemonic('b');
        Mnemonics.setLocalizedText((AbstractButton)this.browseNetteButton, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.browseNetteButton.text"));
        this.browseNetteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Nette2OptionsPanel.this.browseNetteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.jLabel1.text"));
        this.sandboxLabel.setDisplayedMnemonic('s');
        this.sandboxLabel.setLabelFor(this.sandboxTextField);
        Mnemonics.setLocalizedText((JLabel)this.sandboxLabel, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.sandboxLabel.text"));
        this.sandboxTextField.setText(NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.sandboxTextField.text"));
        this.browseSandboxButton.setMnemonic('r');
        Mnemonics.setLocalizedText((AbstractButton)this.browseSandboxButton, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.browseSandboxButton.text"));
        this.browseSandboxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Nette2OptionsPanel.this.browseSandboxButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Nette2OptionsPanel.class, (String)"Nette2OptionsPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sandboxLabel).addComponent(this.netteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.netteTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseNetteButton)).addGroup(layout.createSequentialGroup().addComponent(this.sandboxTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseSandboxButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(0, 66, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.netteLabel).addComponent(this.netteTextField, -2, -1, -2).addComponent(this.browseNetteButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sandboxLabel).addComponent(this.sandboxTextField, -2, -1, -2).addComponent(this.browseSandboxButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 81, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseNetteButtonActionPerformed(ActionEvent evt) {
        File netteDirectory = new FileChooserBuilder(Nette2OptionsPanel.class.getName() + NETTE_DIRECTORY_SUFFIX).setTitle(Bundle.LBL_SelectNetteDirectory()).setDirectoriesOnly(true).showOpenDialog();
        if (netteDirectory != null) {
            netteDirectory = FileUtil.normalizeFile((File)netteDirectory);
            this.netteTextField.setText(netteDirectory.getAbsolutePath());
        }
    }

    private void browseSandboxButtonActionPerformed(ActionEvent evt) {
        File sandboxDirectory = new FileChooserBuilder(Nette2OptionsPanel.class.getName() + NETTE_SANDBOX_SUFFIX).setTitle(Bundle.LBL_SelectNetteSandbox()).setDirectoriesOnly(true).showOpenDialog();
        if (sandboxDirectory != null) {
            sandboxDirectory = FileUtil.normalizeFile((File)sandboxDirectory);
            this.sandboxTextField.setText(sandboxDirectory.getAbsolutePath());
        }
    }
}

