/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.sax.SAXSubParser;
import com.thaiopensource.relaxng.parse.sax.SchemaParser;
import com.thaiopensource.relaxng.parse.sax.UriResolver;
import com.thaiopensource.util.Uri;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParseable
extends SAXSubParser
implements SubParseable {
    private final SAXSource source;

    public SAXParseable(SAXSource sAXSource, UriResolver uriResolver, ErrorHandler errorHandler) {
        super(uriResolver, errorHandler);
        this.source = sAXSource;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseAsInclude(SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public String getUri() {
        return Uri.escapeDisallowedChars(this.source.getInputSource().getSystemId());
    }
}

