/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.completion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.latte.completion.LatteDocumentation;
import org.netbeans.modules.php.latte.completion.LatteDocumentationFactory;
import org.openide.filesystems.FileObject;

public interface LatteElement
extends ElementHandle {
    public String getTemplate();

    public void formatParameters(HtmlFormatter var1);

    public String getDocumentationText();

    public static final class MacroParameter
    extends Parameter {
        public MacroParameter(String name) {
            this(name, null);
        }

        public MacroParameter(String name, String defaultValue) {
            super(" ", name, defaultValue);
        }
    }

    public static final class HelperParameter
    extends Parameter {
        public HelperParameter(String name) {
            this(name, null);
        }

        public HelperParameter(String name, String defaultValue) {
            super(":", name, defaultValue);
        }
    }

    public static class Parameter {
        private final String delimiter;
        private final String name;
        private final String defaultValue;

        public Parameter(String delimiter, String name, String defaultValue) {
            this.delimiter = delimiter;
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Parameter(String delimiter, String name) {
            this(delimiter, name, null);
        }

        public void format(HtmlFormatter formatter) {
            formatter.parameters(true);
            if (this.isMandatory()) {
                formatter.appendText(this.name);
            } else {
                formatter.appendText(this.name);
                formatter.appendText("=");
                formatter.appendText(this.defaultValue);
            }
            formatter.parameters(false);
        }

        public void prepareTemplate(StringBuilder template) {
            if (this.isMandatory()) {
                template.append(this.getDelimiter()).append("${").append(this.name).append("}");
            }
        }

        private boolean isMandatory() {
            return this.defaultValue == null;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }

    public static class LatteElementExtended
    extends BaseLatteElementItem {
        private final List<Parameter> parameters;
        private final String customTemplate;

        public LatteElementExtended(String name, List<Parameter> parameters, LatteDocumentationFactory documentationFactory) {
            this(name, parameters, null, documentationFactory);
        }

        public LatteElementExtended(String name, List<Parameter> parameters, String customTemplate, LatteDocumentationFactory documentationFactory) {
            super(name, documentationFactory);
            this.parameters = parameters;
            this.customTemplate = customTemplate;
        }

        @Override
        public void formatParameters(HtmlFormatter formatter) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter parameter = this.parameters.get(i);
                formatter.appendText(parameter.getDelimiter());
                parameter.format(formatter);
            }
        }

        @Override
        public String getTemplate() {
            String result = this.customTemplate;
            if (result == null) {
                StringBuilder template = new StringBuilder();
                template.append(this.getName());
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter parameter = this.parameters.get(i);
                    parameter.prepareTemplate(template);
                }
                result = template.toString();
            }
            return result;
        }
    }

    public static class LatteElementSimple
    extends BaseLatteElementItem {
        public LatteElementSimple(String name, LatteDocumentationFactory documentationFactory) {
            super(name, documentationFactory);
        }

        @Override
        public String getTemplate() {
            return this.getName();
        }

        @Override
        public void formatParameters(HtmlFormatter formatter) {
        }
    }

    public static abstract class BaseLatteElementItem
    implements LatteElement {
        private final String name;
        private final LatteDocumentationFactory documentationFactory;

        public BaseLatteElementItem(String name, LatteDocumentationFactory documentationFactory) {
            this.name = name;
            this.documentationFactory = documentationFactory;
        }

        public String getName() {
            return this.name;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        @Override
        public String getDocumentationText() {
            LatteDocumentation documentation = this.documentationFactory.create(this.name.startsWith("/") ? this.name.substring(1) : this.name);
            return documentation.getHeader() + documentation.getContent();
        }
    }

    public static class ControlFactory {
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.ControlDocumentationFactory.getInstance();

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }
    }

    public static class VariableFactory {
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.VariableDocumentationFactory.getInstance();

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }
    }

    public static class IteratorItemFactory {
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.IteratorItemDocumentationFactory.getInstance();

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }
    }

    public static class KeywordFactory {
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.KeywordDocumentationFactory.getInstance();

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }
    }

    public static class HelperFactory {
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.HelperDocumentationFactory.getInstance();

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }

        public static LatteElement create(String name, List<Parameter> parameters) {
            return new LatteElementExtended(name, parameters, DF);
        }
    }

    public static class MacroFactory {
        private static final String END_MACRO_MARKER = "/";
        private static final LatteDocumentationFactory DF = LatteDocumentationFactory.MacroDocumentationFactory.getInstance();

        public static LatteElement create(String name, String macroParameter, String customTemplate) {
            return new LatteElementExtended(name, Arrays.asList(new MacroParameter(macroParameter)), customTemplate, DF);
        }

        public static LatteElement create(String name) {
            return new LatteElementSimple(name, DF);
        }

        public static LatteElement createEnd(String name) {
            return new LatteElementSimple(END_MACRO_MARKER + name, DF);
        }
    }
}

