/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.hints;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.php.latte.hints.CaretSensitiveRule;
import org.netbeans.modules.php.latte.hints.InvokableRule;

public class LatteHintsProvider
implements HintsProvider {
    public static final String DEFAULT_HINTS = "default.hints";
    private volatile boolean cancel = false;

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        this.resume();
        Map allHints = manager.getHints(false, context);
        List defaultHints = (List)allHints.get(DEFAULT_HINTS);
        RulesRunnerImpl<Hint> rulesRunner = new RulesRunnerImpl<Hint>(manager, context, hints);
        rulesRunner.run(defaultHints, new ResetCaretOffsetAdjuster());
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        this.resume();
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
        this.resume();
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        this.resume();
        unhandled.addAll(context.parserResult.getDiagnostics());
    }

    public void cancel() {
        this.cancel = true;
    }

    private void resume() {
        this.cancel = false;
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new LatteRuleContext();
    }

    private static final class CaretOffsetAdjuster
    implements RuleAdjuster {
        private final int caretOffset;

        public CaretOffsetAdjuster(int caretOffset) {
            this.caretOffset = caretOffset;
        }

        @Override
        public void adjust(Rule rule) {
            if (rule instanceof CaretSensitiveRule) {
                CaretSensitiveRule caretSensitiveRule = (CaretSensitiveRule)rule;
                caretSensitiveRule.setCaretOffset(this.caretOffset);
            }
        }
    }

    private static final class ResetCaretOffsetAdjuster
    implements RuleAdjuster {
        private final RuleAdjuster caretOffsetAdjuster = new CaretOffsetAdjuster(-1);

        @Override
        public void adjust(Rule rule) {
            this.caretOffsetAdjuster.adjust(rule);
        }
    }

    private static interface RuleAdjuster {
        public static final RuleAdjuster NONE = new RuleAdjuster(){

            @Override
            public void adjust(Rule rule) {
            }
        };

        public void adjust(Rule var1);
    }

    private final class RulesRunnerImpl<T>
    implements RulesRunner<T> {
        private final HintsProvider.HintsManager hintManager;
        private final RuleContext ruleContext;
        private final List<T> result;

        public RulesRunnerImpl(HintsProvider.HintsManager hintManager, RuleContext ruleContext, List<T> result) {
            this.hintManager = hintManager;
            this.ruleContext = ruleContext;
            this.result = result;
        }

        @Override
        public void run(List<? extends Rule> rules, RuleAdjuster adjuster) {
            for (Rule rule : rules) {
                if (LatteHintsProvider.this.cancel) break;
                if (rule instanceof Rule.AstRule) {
                    Rule.AstRule astRule = (Rule.AstRule)rule;
                    if (!this.hintManager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                    this.adjustAndInvoke(rule, adjuster);
                    continue;
                }
                if (!(rule instanceof Rule.ErrorRule)) continue;
                this.adjustAndInvoke(rule, adjuster);
            }
        }

        private void adjustAndInvoke(Rule rule, RuleAdjuster adjuster) {
            if (LatteHintsProvider.this.cancel) {
                return;
            }
            if (rule instanceof InvokableRule) {
                adjuster.adjust(rule);
                InvokableRule invokableRule = (InvokableRule)rule;
                if (LatteHintsProvider.this.cancel) {
                    return;
                }
                invokableRule.invoke(this.ruleContext, this.result);
            }
        }
    }

    private static interface RulesRunner<T> {
        public void run(List<? extends Rule> var1, RuleAdjuster var2);
    }

    public static final class LatteRuleContext
    extends RuleContext {
    }
}

