/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.typinghooks;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.modules.php.twig.editor.typinghooks.TypingHooksUtils;
import org.netbeans.modules.php.twig.editor.ui.options.OptionsUtils;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;

public class TwigDeletedTextInterceptor
implements DeletedTextInterceptor {
    private final boolean isTwig;
    private final MimePath mimePath;

    private TwigDeletedTextInterceptor(MimePath mimePath) {
        this.mimePath = mimePath;
        String path = mimePath.getPath();
        this.isTwig = path.contains("text/x-twig");
    }

    public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        char ch;
        if (this.isTwig && TypingHooksUtils.isOpeningDelimiterChar(ch = context.getText().charAt(0))) {
            BaseDocument doc = (BaseDocument)context.getDocument();
            AtomicBoolean removed = new AtomicBoolean();
            AtomicReference ble = new AtomicReference();
            doc.runAtomic(() -> {
                BeforeRemover remover = BeforeRemoverFactory.create(ch);
                try {
                    removed.set(remover.beforeRemove(context));
                }
                catch (BadLocationException ex) {
                    ble.set(ex);
                }
            });
            if (ble.get() != null) {
                throw (BadLocationException)ble.get();
            }
            return removed.get();
        }
        return false;
    }

    public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        if (!this.isTwig) {
            return;
        }
        char c = context.getText().charAt(0);
        Remover remover = RemoverFactory.create(c);
        remover.remove(context);
    }

    public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(DeletedTextInterceptor.Context context) {
    }

    public static class Factory
    implements DeletedTextInterceptor.Factory {
        public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
            return new TwigDeletedTextInterceptor(mimePath);
        }
    }

    private static final class DoubleQuoteRemover
    extends QuoteRemover {
        private DoubleQuoteRemover() {
        }

        @Override
        protected char getQuote() {
            return '\"';
        }
    }

    private static final class SingleQuoteRemover
    extends QuoteRemover {
        private SingleQuoteRemover() {
        }

        @Override
        protected char getQuote() {
            return '\'';
        }
    }

    private static abstract class QuoteRemover
    implements Remover {
        private QuoteRemover() {
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            if (OptionsUtils.autoCompletionSmartQuotes()) {
                char[] match;
                int dotPos;
                BaseDocument doc = (BaseDocument)context.getDocument();
                TokenSequence<? extends TokenId> ts = TwigLexerUtils.getTwigMarkupTokenSequence((Document)doc, dotPos = context.getOffset() - 1);
                if (ts != null) {
                    TokenId id;
                    ts.move(dotPos);
                    if ((ts.moveNext() || ts.movePrevious()) && ((id = ts.token().id()) == TwigBlockTokenId.T_TWIG_STRING || id == TwigVariableTokenId.T_TWIG_STRING) && TypingHooksUtils.isEscapeSequence(doc, dotPos)) {
                        doc.remove(dotPos - 1, 1);
                        return;
                    }
                }
                if ((match = doc.getChars(dotPos, 1)) != null && match[0] == this.getQuote()) {
                    doc.remove(dotPos, 1);
                }
            }
        }

        protected abstract char getQuote();
    }

    private static final class RoundBracketRemover
    extends BracketRemover {
        private RoundBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '(';
        }

        @Override
        protected char getClosingBracket() {
            return ')';
        }
    }

    private static final class SquareBracketRemover
    extends BracketRemover {
        private SquareBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '[';
        }

        @Override
        protected char getClosingBracket() {
            return ']';
        }
    }

    private static final class CurlyBracketRemover
    extends BracketRemover {
        private CurlyBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '{';
        }

        @Override
        protected char getClosingBracket() {
            return '}';
        }
    }

    private static abstract class BracketRemover
    implements Remover {
        private BracketRemover() {
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            if (TypingHooksUtils.isInsertMatchingEnabled()) {
                BaseDocument doc = (BaseDocument)context.getDocument();
                int dotPos = context.getOffset() - 1;
                if (TypingHooksUtils.sameAsExistingChar(doc, this.getClosingBracket(), dotPos) && TwigLexerUtils.getTokenBalance(doc, this.getOpeningBracket(), this.getClosingBracket(), dotPos) < 0) {
                    doc.remove(dotPos, 1);
                }
            }
        }

        protected abstract char getOpeningBracket();

        protected abstract char getClosingBracket();
    }

    private static final class RemoverFactory {
        private RemoverFactory() {
        }

        static Remover create(char ch) {
            Remover remover;
            switch (ch) {
                case '{': {
                    remover = new CurlyBracketRemover();
                    break;
                }
                case '(': {
                    remover = new RoundBracketRemover();
                    break;
                }
                case '[': {
                    remover = new SquareBracketRemover();
                    break;
                }
                case '\"': {
                    remover = new DoubleQuoteRemover();
                    break;
                }
                case '\'': {
                    remover = new SingleQuoteRemover();
                    break;
                }
                default: {
                    remover = Remover.NONE;
                }
            }
            return remover;
        }
    }

    private static interface Remover {
        public static final Remover NONE = context -> {};

        public void remove(DeletedTextInterceptor.Context var1) throws BadLocationException;
    }

    private static final class VariableDelimiterRemover
    extends DelimiterRemover {
        private VariableDelimiterRemover() {
        }

        @Override
        protected TwigTopTokenId getOpeningId() {
            return TwigTopTokenId.T_TWIG_VAR_START;
        }

        @Override
        protected TwigTopTokenId getClosingId() {
            return TwigTopTokenId.T_TWIG_VAR_END;
        }
    }

    private static final class BlockDelimiterRemover
    extends DelimiterRemover {
        private BlockDelimiterRemover() {
        }

        @Override
        protected TwigTopTokenId getOpeningId() {
            return TwigTopTokenId.T_TWIG_BLOCK_START;
        }

        @Override
        protected TwigTopTokenId getClosingId() {
            return TwigTopTokenId.T_TWIG_BLOCK_END;
        }
    }

    private static abstract class DelimiterRemover
    implements BeforeRemover {
        private DelimiterRemover() {
        }

        @Override
        public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
            if (OptionsUtils.autoCompletionSmartDelimiters()) {
                int dotPos = context.getOffset();
                Document document = context.getDocument();
                TokenSequence<? extends TwigTopTokenId> ts = TwigLexerUtils.getTwigTokenSequence(document, dotPos);
                if (ts != null) {
                    ts.move(dotPos);
                    if (ts.movePrevious() && ts.token().id() == this.getOpeningId() && ts.offset() == dotPos - 2) {
                        ts.move(dotPos);
                        if (ts.moveNext() && ts.token().id() == this.getClosingId() && ts.offset() == dotPos) {
                            document.remove(dotPos - 2, 4);
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        protected abstract TwigTopTokenId getOpeningId();

        protected abstract TwigTopTokenId getClosingId();
    }

    private static final class BeforeRemoverFactory {
        private BeforeRemoverFactory() {
        }

        public static BeforeRemover create(char c) {
            switch (c) {
                case '%': {
                    return new BlockDelimiterRemover();
                }
                case '{': {
                    return new VariableDelimiterRemover();
                }
            }
            assert (false);
            return BeforeRemover.NONE;
        }
    }

    private static interface BeforeRemover {
        public static final BeforeRemover NONE = context -> false;

        public boolean beforeRemove(DeletedTextInterceptor.Context var1) throws BadLocationException;
    }
}

