/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.ide;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.jakartaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.payara.jakartaee.ide.MonitorProgressObject;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.admin.CommandGetProperty;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.openide.util.RequestProcessor;

public class UpdateContextRoot
implements ProgressListener {
    private MonitorProgressObject returnProgress;
    private Hk2TargetModuleID moduleId;
    private ServerInstance si;
    private boolean needToDo;
    private static final RequestProcessor RP = new RequestProcessor("UpdateContextRoot", 5);

    public UpdateContextRoot(MonitorProgressObject returnProgress, Hk2TargetModuleID moduleId, ServerInstance si, boolean needToDo) {
        this.returnProgress = returnProgress;
        this.moduleId = moduleId;
        this.si = si;
        this.needToDo = needToDo;
    }

    public void handleProgressEvent(ProgressEvent event) {
        if (event.getDeploymentStatus().isCompleted()) {
            if (this.needToDo) {
                this.returnProgress.operationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, event.getDeploymentStatus().getMessage());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PayaraServer server = ((PayaraModule)UpdateContextRoot.this.si.getBasicNode().getLookup().lookup(PayaraModule.class)).getInstance();
                            ResultMap result = CommandGetProperty.getProperties((PayaraServer)server, (String)"applications.application.*.context-root");
                            if (result.getState() == TaskState.COMPLETED) {
                                Map retVal = result.getValue();
                                String newCR = (String)retVal.get("applications.application." + UpdateContextRoot.this.moduleId.getModuleID() + ".context-root");
                                if (null != newCR) {
                                    UpdateContextRoot.this.moduleId.setPath(newCR);
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "updated the moduleid");
                                } else {
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "no moduleid update necessary");
                                }
                            } else {
                                UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "no moduleid update necessary");
                            }
                        }
                        catch (PayaraIdeException gfie) {
                            Logger.getLogger("payara-jakartaee").log(Level.INFO, "Could not retrieve property from server when updating module id.", gfie);
                        }
                    }
                });
            } else {
                this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, event.getDeploymentStatus().getMessage());
            }
        } else if (event.getDeploymentStatus().isFailed()) {
            this.returnProgress.operationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, event.getDeploymentStatus().getMessage());
        } else {
            this.returnProgress.operationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, event.getDeploymentStatus().getMessage());
        }
    }
}

