/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.editor.BaseAction;
import org.netbeans.lib.editor.bookmarks.actions.ClearDocumentBookmarksAction;
import org.netbeans.lib.editor.bookmarks.actions.GotoBookmarkAction;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkHistoryPopupAction;
import org.openide.awt.Actions;
import org.openide.util.ImageUtilities;

public class WrapperBookmarkAction
extends AbstractAction
implements PropertyChangeListener {
    static final long serialVersionUID = 0L;
    protected Action originalAction;

    public WrapperBookmarkAction(Action originalAction) {
        this.originalAction = originalAction;
        this.putValue("Name", originalAction.getValue("ShortDescription"));
        this.putValue("ShortDescription", Actions.cutAmpersand((String)((String)originalAction.getValue("ShortDescription"))));
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)((String)originalAction.getValue("IconResource")), (boolean)false));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.updateEnabled();
        originalAction.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        this.setEnabled(this.originalAction.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.originalAction.actionPerformed(e);
    }

    public static final class ClearDocumentBookmarks
    extends WrapperBookmarkAction {
        public ClearDocumentBookmarks() {
            super((Action)((Object)new ClearDocumentBookmarksAction()));
        }
    }

    public static final class PopupPrevious
    extends WrapperBookmarkAction {
        public PopupPrevious() {
            super((Action)((Object)BookmarkHistoryPopupAction.createPrevious()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BaseAction)this.originalAction).actionPerformed(e, null);
        }
    }

    public static final class PopupNext
    extends WrapperBookmarkAction {
        public PopupNext() {
            super((Action)((Object)BookmarkHistoryPopupAction.createNext()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BaseAction)this.originalAction).actionPerformed(e, null);
        }
    }

    public static final class Previous
    extends WrapperBookmarkAction {
        public Previous() {
            super((Action)((Object)GotoBookmarkAction.createPrevious()));
        }
    }

    public static final class Next
    extends WrapperBookmarkAction {
        public Next() {
            super((Action)((Object)GotoBookmarkAction.createNext()));
        }
    }
}

