/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public abstract class AbstractRefactoringElement
extends SimpleRefactoringElementImplementation
implements RefactoringElementImplementation {
    private int status = 0;
    protected String name;
    protected final FileObject parentFile;
    protected boolean enabled = true;
    private int[] loc;

    protected AbstractRefactoringElement(@NonNull FileObject parentFile) {
        Parameters.notNull((CharSequence)"parentFile", (Object)parentFile);
        this.parentFile = parentFile;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getText() {
        return this.getDisplayText();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    protected int[] location() {
        return new int[]{0, 0};
    }

    public PositionBounds getPosition() {
        try {
            EditorCookie.Observable obs;
            DataObject dobj = DataObject.find((FileObject)this.getParentFile());
            if (dobj != null && (obs = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) != null && obs instanceof CloneableEditorSupport) {
                CloneableEditorSupport supp = (CloneableEditorSupport)obs;
                if (this.loc == null) {
                    this.loc = this.location();
                }
                PositionBounds bounds = new PositionBounds(supp.createPositionRef(this.loc[0], Position.Bias.Forward), supp.createPositionRef(Math.max(this.loc[0], this.loc[1]), Position.Bias.Forward));
                return bounds;
            }
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void performChange() {
    }

    public void undoChange() {
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }
}

