/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.util.NbBundle;

class MappingTable
extends JTable {
    private boolean fontChanged = true;
    private int margin = 6;
    private static final long serialVersionUID = 3482048644419079279L;

    MappingTable(String filterName, List<FilterMappingData> filterMappings) {
        this.setModel(new MappingTableModel(filterName, filterMappings));
        TableColumnModel tcm = this.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(72);
        tcm.getColumn(1).setPreferredWidth(72);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension(this.margin, this.margin));
    }

    List<FilterMappingData> getFilterMappings() {
        return ((MappingTableModel)this.getModel()).getFilterMappings();
    }

    void setFilterName(String name) {
        ((MappingTableModel)this.getModel()).setFilterName(name);
        this.invalidate();
    }

    void addRow(FilterMappingData fmd) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(fmd);
    }

    void addRow(int row, FilterMappingData fmd) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(row, fmd);
    }

    void setRow(int row, FilterMappingData fmd) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).setRow(row, fmd);
    }

    FilterMappingData getRow(int row) {
        return ((MappingTableModel)this.getModel()).getRow(row);
    }

    void moveRowUp(int row) {
        ((MappingTableModel)this.getModel()).moveRowUp(row);
        this.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        this.invalidate();
    }

    void moveRowDown(int row) {
        ((MappingTableModel)this.getModel()).moveRowUp(row + 1);
        this.getSelectionModel().setSelectionInterval(row + 1, row + 1);
        this.invalidate();
    }

    void removeRow(int row) {
        ((MappingTableModel)this.getModel()).removeRow(row);
        this.invalidate();
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
    }

    private void setColors(boolean editable) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color bg = !editable ? this.getBackground().darker() : Color.white;
        this.setBackground(bg);
    }

    void addTableModelListener(TableModelListener tml) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.addTableModelListener(tml);
        }
    }

    void removeTableModelListener(TableModelListener tml) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(tml);
        }
    }

    @Override
    public void setFont(Font f) {
        this.fontChanged = true;
        super.setFont(f);
    }

    @Override
    public void paint(Graphics g) {
        if (this.fontChanged) {
            this.fontChanged = false;
            int height = 0;
            FontMetrics fm = g.getFontMetrics(this.getFont());
            height = fm.getHeight() + this.margin;
            if (height > this.rowHeight) {
                this.rowHeight = height;
            }
            this.setRowHeight(this.rowHeight);
            return;
        }
        super.paint(g);
    }

    private static class MappingTableModel
    extends AbstractTableModel {
        private final String[] colheaders = new String[]{NbBundle.getMessage(MappingTable.class, (String)"LBL_filter_name"), NbBundle.getMessage(MappingTable.class, (String)"LBL_applies_to")};
        private List<FilterMappingData> filterMappings = null;
        private String filterName;
        private static final long serialVersionUID = 2845252365404044474L;

        MappingTableModel(String filterName, List<FilterMappingData> filterMappings) {
            this.filterName = filterName;
            this.filterMappings = filterMappings;
        }

        List<FilterMappingData> getFilterMappings() {
            return this.filterMappings;
        }

        void setFilterName(String name) {
            for (FilterMappingData fmd : this.filterMappings) {
                if (!fmd.getName().equals(this.filterName)) continue;
                fmd.setName(name);
            }
            this.filterName = name;
        }

        @Override
        public int getColumnCount() {
            return this.colheaders.length;
        }

        @Override
        public int getRowCount() {
            return this.filterMappings.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.colheaders[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            FilterMappingData fmd = this.filterMappings.get(row);
            if (col == 0) {
                return fmd.getName();
            }
            return fmd.getPattern();
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        void addRow(int row, FilterMappingData fmd) {
            this.filterMappings.add(row, fmd);
        }

        void addRow(FilterMappingData fmd) {
            this.filterMappings.add(fmd);
        }

        FilterMappingData getRow(int row) {
            return this.filterMappings.get(row);
        }

        void setRow(int row, FilterMappingData fmd) {
            this.filterMappings.set(row, fmd);
        }

        void moveRowUp(int row) {
            FilterMappingData o = this.filterMappings.remove(row);
            this.filterMappings.add(row - 1, o);
        }

        void removeRow(int row) {
            this.filterMappings.remove(row);
        }
    }
}

