/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorMessDetectorParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListCellRenderer;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListModel;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MessDetectorOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = -8206936666925671148L;
    private final MessDetectorRuleSetsListModel ruleSetsListModel = new MessDetectorRuleSetsListModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton messDetectorBrowseButton;
    private JLabel messDetectorHintLabel;
    private JLabel messDetectorLabel;
    private JLabel messDetectorLearnMoreLabel;
    private JLabel messDetectorOptionsLabel;
    private JTextField messDetectorOptionsTextField;
    private JButton messDetectorRuleSetFileBrowseButton;
    private JLabel messDetectorRuleSetFileLabel;
    private JTextField messDetectorRuleSetFileTextField;
    private JLabel messDetectorRuleSetsLabel;
    private JList<String> messDetectorRuleSetsList;
    private JScrollPane messDetectorRuleSetsScrollPane;
    private JButton messDetectorSearchButton;
    private JTextField messDetectorTextField;
    private JLabel minVersionInfoLabel;
    private JLabel noteLabel;

    public MessDetectorOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.fireChange());
        this.initMessDetector(defaultDocumentListener);
    }

    private void initMessDetector(DocumentListener defaultDocumentListener) {
        this.messDetectorHintLabel.setText(Bundle.MessDetectorOptionsPanel_hint("phpmd", MessDetector.LONG_NAME));
        this.messDetectorTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.messDetectorRuleSetsList.addListSelectionListener(new DefaultListSelectionListener());
        this.messDetectorRuleSetFileTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.messDetectorOptionsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.messDetectorRuleSetsList.setModel(this.ruleSetsListModel);
        this.messDetectorRuleSetsList.setCellRenderer(new MessDetectorRuleSetsListCellRenderer(this.messDetectorRuleSetsList.getCellRenderer()));
    }

    public String getMessDetectorPath() {
        return this.messDetectorTextField.getText();
    }

    public void setMessDetectorPath(String path) {
        this.messDetectorTextField.setText(path);
    }

    public List<String> getMessDetectorRuleSets() {
        return this.getSelectedRuleSets();
    }

    public void setMessDetectorRuleSets(List<String> ruleSets) {
        this.selectRuleSets(ruleSets);
    }

    public String getMessDetectorRuleSetFilePath() {
        return this.messDetectorRuleSetFileTextField.getText().trim();
    }

    private void setMessDetectorRuleSetFilePath(String path) {
        this.messDetectorRuleSetFileTextField.setText(path);
    }

    public String getMessDetectorOptions() {
        return this.messDetectorOptionsTextField.getText().trim();
    }

    private void setMessDetectorOptions(String options) {
        this.messDetectorOptionsTextField.setText(options);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    List<String> getSelectedRuleSets() {
        return this.messDetectorRuleSetsList.getSelectedValuesList();
    }

    void selectRuleSets(List<String> ruleSets) {
        this.messDetectorRuleSetsList.clearSelection();
        for (String ruleSet : ruleSets) {
            int indexOf = MessDetectorRuleSetsListModel.getAllRuleSets().indexOf(ruleSet);
            assert (indexOf != -1) : "Rule set not found: " + ruleSet;
            this.messDetectorRuleSetsList.addSelectionInterval(indexOf, indexOf);
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @Override
    public String getCategoryName() {
        return Bundle.MessDetectorOptionsPanel_category_name();
    }

    @Override
    public void update() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        this.setMessDetectorPath(analysisOptions.getMessDetectorPath());
        this.setMessDetectorRuleSets(analysisOptions.getMessDetectorRuleSets());
        this.setMessDetectorRuleSetFilePath(analysisOptions.getMessDetectorRuleSetFilePath());
        this.setMessDetectorOptions(analysisOptions.getMessDetectorOptions());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        analysisOptions.setMessDetectorPath(this.getMessDetectorPath());
        analysisOptions.setMessDetectorRuleSets(this.getMessDetectorRuleSets());
        analysisOptions.setMessDetectorRuleSetFilePath(this.getMessDetectorRuleSetFilePath());
        analysisOptions.setMessDetectorOptions(this.getMessDetectorOptions());
    }

    @Override
    public boolean isChanged() {
        String saved = AnalysisOptions.getInstance().getMessDetectorPath();
        String current = this.getMessDetectorRuleSetFilePath();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getMessDetectorRuleSetFilePath();
        current = this.getMessDetectorRuleSetFilePath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getMessDetectorOptions();
        current = this.getMessDetectorOptions().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        return !AnalysisOptions.getInstance().getMessDetectorRuleSets().equals(this.getMessDetectorRuleSets());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validateMessDetector(ValidatorMessDetectorParameter.create(this)).getResult();
    }

    private void initComponents() {
        this.messDetectorLabel = new JLabel();
        this.messDetectorTextField = new JTextField();
        this.messDetectorBrowseButton = new JButton();
        this.messDetectorSearchButton = new JButton();
        this.messDetectorHintLabel = new JLabel();
        this.messDetectorRuleSetsLabel = new JLabel();
        this.messDetectorRuleSetsScrollPane = new JScrollPane();
        this.messDetectorRuleSetsList = new JList();
        this.noteLabel = new JLabel();
        this.minVersionInfoLabel = new JLabel();
        this.messDetectorLearnMoreLabel = new JLabel();
        this.messDetectorRuleSetFileTextField = new JTextField();
        this.messDetectorRuleSetFileLabel = new JLabel();
        this.messDetectorRuleSetFileBrowseButton = new JButton();
        this.messDetectorOptionsTextField = new JTextField();
        this.messDetectorOptionsLabel = new JLabel();
        this.messDetectorLabel.setLabelFor(this.messDetectorTextField);
        Mnemonics.setLocalizedText((JLabel)this.messDetectorLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.messDetectorBrowseButton, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorBrowseButton.text"));
        this.messDetectorBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.messDetectorSearchButton, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorSearchButton.text"));
        this.messDetectorSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.messDetectorHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.messDetectorRuleSetsLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorRuleSetsLabel.text"));
        this.messDetectorRuleSetsScrollPane.setViewportView(this.messDetectorRuleSetsList);
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minVersionInfoLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.minVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.messDetectorLearnMoreLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorLearnMoreLabel.text"));
        this.messDetectorLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorLearnMoreLabelMousePressed(evt);
            }
        });
        this.messDetectorRuleSetFileLabel.setLabelFor(this.messDetectorRuleSetFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.messDetectorRuleSetFileLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorRuleSetFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.messDetectorRuleSetFileBrowseButton, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorRuleSetFileBrowseButton.text"));
        this.messDetectorRuleSetFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorRuleSetFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.messDetectorOptionsLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorOptionsLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minVersionInfoLabel).addComponent(this.messDetectorLearnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messDetectorLabel).addComponent(this.messDetectorRuleSetsLabel).addComponent(this.messDetectorRuleSetFileLabel).addComponent(this.messDetectorOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messDetectorRuleSetsScrollPane, GroupLayout.Alignment.LEADING).addComponent(this.messDetectorTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.messDetectorHintLabel).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messDetectorOptionsTextField, GroupLayout.Alignment.LEADING).addComponent(this.messDetectorRuleSetFileTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorRuleSetFileBrowseButton).addGap(83, 83, 83)))));
        layout.linkSize(0, this.messDetectorBrowseButton, this.messDetectorSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messDetectorTextField, -2, -1, -2).addComponent(this.messDetectorSearchButton).addComponent(this.messDetectorBrowseButton).addComponent(this.messDetectorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messDetectorRuleSetsLabel).addGroup(layout.createSequentialGroup().addComponent(this.messDetectorRuleSetsScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messDetectorRuleSetFileTextField, -2, -1, -2).addComponent(this.messDetectorRuleSetFileBrowseButton).addComponent(this.messDetectorRuleSetFileLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messDetectorOptionsTextField, -2, -1, -2).addComponent(this.messDetectorOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorLearnMoreLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.messDetectorRuleSetFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorRuleSetFileLabel.AccessibleContext.accessibleName"));
    }

    private void messDetectorLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void messDetectorLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://phpmd.org/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void messDetectorBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseMessDetector();
        if (file != null) {
            this.messDetectorTextField.setText(file.getAbsolutePath());
        }
    }

    private void messDetectorSearchButtonActionPerformed(ActionEvent evt) {
        String messDetector = AnalysisUiUtils.searchMessDetector();
        if (messDetector != null) {
            this.messDetectorTextField.setText(messDetector);
        }
    }

    private void messDetectorRuleSetFileBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseMessDetectorRuleSet();
        if (file != null) {
            this.messDetectorRuleSetFileTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultListSelectionListener
    implements ListSelectionListener {
        private DefaultListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MessDetectorOptionsPanel.this.fireChange();
        }
    }
}

