/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;

public final class EntityGenerator {
    private static final String BMP_EJBCLASS = "Templates/J2EE/EJB21/BmpEjbClass.java";
    private static final String BMP_LOCAL = "Templates/J2EE/EJB21/BmpLocal.java";
    private static final String BMP_LOCALHOME = "Templates/J2EE/EJB21/BmpLocalHome.java";
    private static final String BMP_REMOTE = "Templates/J2EE/EJB21/BmpRemote.java";
    private static final String BMP_REMOTEHOME = "Templates/J2EE/EJB21/BmpRemoteHome.java";
    private static final String CMP_EJBCLASS = "Templates/J2EE/EJB21/CmpEjbClass.java";
    private static final String CMP_LOCAL = "Templates/J2EE/EJB21/CmpLocal.java";
    private static final String CMP_LOCALHOME = "Templates/J2EE/EJB21/CmpLocalHome.java";
    private static final String CMP_REMOTE = "Templates/J2EE/EJB21/CmpRemote.java";
    private static final String CMP_REMOTEHOME = "Templates/J2EE/EJB21/CmpRemoteHome.java";
    private final FileObject pkg;
    private final boolean hasRemote;
    private final boolean hasLocal;
    private final boolean isCMP;
    private final String primaryKeyClassName;
    private final String wizardTargetName;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String remoteName;
    private final String remoteHomeName;
    private final String localName;
    private final String localHomeName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, String> templateParameters;
    private final String primaryKeyName;

    public static EntityGenerator create(String wizardTargetName, FileObject pkg, boolean hasRemote, boolean hasLocal, boolean isCMP, String primaryKeyClassName, String primaryKeyName) {
        return new EntityGenerator(wizardTargetName, pkg, hasRemote, hasLocal, isCMP, primaryKeyClassName, primaryKeyName, false);
    }

    protected EntityGenerator(String wizardTargetName, FileObject pkg, boolean hasRemote, boolean hasLocal, boolean isCMP, String primaryKeyClassName, String primaryKeyName, boolean isTest) {
        this.pkg = pkg;
        this.hasRemote = hasRemote;
        this.hasLocal = hasLocal;
        this.isCMP = isCMP;
        this.primaryKeyClassName = primaryKeyClassName;
        this.primaryKeyName = primaryKeyName;
        this.wizardTargetName = wizardTargetName;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getEntityEjbNamePrefix() + wizardTargetName + this.ejbNameOptions.getEntityEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getEntityEjbClassPrefix() + wizardTargetName + this.ejbNameOptions.getEntityEjbClassSuffix();
        this.remoteName = this.ejbNameOptions.getEntityRemotePrefix() + wizardTargetName + this.ejbNameOptions.getEntityRemoteSuffix();
        this.remoteHomeName = this.ejbNameOptions.getEntityRemoteHomePrefix() + wizardTargetName + this.ejbNameOptions.getEntityRemoteHomeSuffix();
        this.localName = this.ejbNameOptions.getEntityLocalPrefix() + wizardTargetName + this.ejbNameOptions.getEntityLocalSuffix();
        this.localHomeName = this.ejbNameOptions.getEntityLocalHomePrefix() + wizardTargetName + this.ejbNameOptions.getEntityLocalHomeSuffix();
        this.displayName = this.ejbNameOptions.getEntityDisplayNamePrefix() + wizardTargetName + this.ejbNameOptions.getEntityDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(pkg);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, String>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("primaryKey", primaryKeyClassName);
        this.templateParameters.put("primaryKeyName", primaryKeyName);
        this.templateParameters.put("localInterface", this.packageNameWithDot + this.localName);
        this.templateParameters.put("remoteInterface", this.packageNameWithDot + this.remoteName);
        if (isTest) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public FileObject generate() throws IOException {
        FileObject resultFileObject = null;
        resultFileObject = this.isCMP ? this.generateCmpClasses() : this.generateBmpClasses();
        Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
        this.generateXml();
        return resultFileObject;
    }

    private FileObject generateBmpClasses() throws IOException {
        FileObject ejbClassFO = GenerationUtils.createClass((String)BMP_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)BMP_REMOTE, (FileObject)this.pkg, (String)this.remoteName, null, this.templateParameters);
            GenerationUtils.createClass((String)BMP_REMOTEHOME, (FileObject)this.pkg, (String)this.remoteHomeName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)BMP_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
            GenerationUtils.createClass((String)BMP_LOCALHOME, (FileObject)this.pkg, (String)this.localHomeName, null, this.templateParameters);
        }
        return ejbClassFO;
    }

    private FileObject generateCmpClasses() throws IOException {
        FileObject ejbClassFO = GenerationUtils.createClass((String)CMP_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)CMP_REMOTE, (FileObject)this.pkg, (String)this.remoteName, null, this.templateParameters);
            GenerationUtils.createClass((String)CMP_REMOTEHOME, (FileObject)this.pkg, (String)this.remoteHomeName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)CMP_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
            GenerationUtils.createClass((String)CMP_LOCALHOME, (FileObject)this.pkg, (String)this.localHomeName, null, this.templateParameters);
        }
        return ejbClassFO;
    }

    private void generateXml() throws IOException {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = DDProvider.getDefault().getDDRoot(ejbModule.getDeploymentDescriptor());
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            enterpriseBeans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(enterpriseBeans);
        }
        Entity entity = enterpriseBeans.newEntity();
        entity.setEjbName(this.ejbName);
        entity.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        entity.setPrimKeyClass(this.primaryKeyClassName);
        entity.setReentrant(false);
        entity.setDisplayName(this.displayName);
        if (this.hasRemote) {
            entity.setRemote(this.packageNameWithDot + this.remoteName);
            entity.setHome(this.packageNameWithDot + this.remoteHomeName);
        }
        if (this.hasLocal) {
            entity.setLocal(this.packageNameWithDot + this.localName);
            entity.setLocalHome(this.packageNameWithDot + this.localHomeName);
        }
        if (this.isCMP) {
            entity.setPersistenceType("Container");
            entity.setAbstractSchemaName(this.wizardTargetName);
            if (this.primaryKeyName == null) {
                CmpField cmpField = entity.newCmpField();
                cmpField.setFieldName("pk");
                entity.addCmpField(cmpField);
                entity.setPrimkeyField("pk");
            } else {
                entity.setPrimkeyField(this.primaryKeyName);
            }
        } else {
            entity.setPersistenceType("Bean");
        }
        enterpriseBeans.addEntity(entity);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
    }
}

