/**
 * @syntax 'string text' "string text" "中文 español deutsch English हिन्दी العربية português বাংলা русский 日本語 ਪੰਜਾਬੀ 한국어 தமிழ்"
 * @returns {String}
 */
function String() {
}
/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.fixed()
 * @returns {String}
 */
String.prototype.fixed = function() {};

/**
 * @syntax str.substr(start[, length])
 * @param {Number} start
 * @param {Number} length
 * @returns {String}
 */
String.prototype.substr = function(start) {};

/**
 * @since ECMAScript6
 * @syntax String.fromCodePoint(num1[, ...[, numN]])
 * @returns {String}
 * @static
 */
String.fromCodePoint = function(num1) {};

/**
 * @syntax str.substring(indexStart[, indexEnd])
 * @param {Number} indexStart
 * @param {Number} indexEnd
 * @returns {String}
 */
String.prototype.substring = function(indexStart) {};

/**
 * @since ECMAScript6
 * @syntax str.includes(searchString[, position])
 * @param {String} searchString
 * @param {String} position
 * @returns {Boolean}
 */
String.prototype.includes = function(searchString) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.small()
 * @returns {String}
 */
String.prototype.small = function() {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.fontsize(size)
 * @param {Number} size
 * @returns {Number}
 */
String.prototype.fontsize = function(size) {};

/**
 * @syntax String.fromCharCode(num1[, ...[, numN]])
 * @returns {String}
 * @static
 */
String.fromCharCode = function(num1) {};

/**
 * @since ECMAScript6
 * @syntax str.link(url)
 * @param {String} url
 * @returns {String}
 */
String.prototype.link = function(url) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.bold()
 * @returns {String}
 */
String.prototype.bold = function() {};

/**
 * @syntax str.trim()
 * @returns {String}
 */
String.prototype.trim = function() {};

/**
 * @syntax str.length
 * @returns {Number}
 * @static
 */
String.length = new Number();

/**
 * @since ECMAScript6
 * @syntax str.codePointAt(pos)
 * @param {String} pos
 * @returns {Number}
 */
String.prototype.codePointAt = function(pos) {};

/**
 * @syntax str.toLocaleUpperCase()
 * @returns {String}
 */
String.prototype.toLocaleUpperCase = function() {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.sub()
 * @returns {String}
 */
String.prototype.sub = function() {};

/**
 * @syntax str.match(regexp)
 * @param {RegExp} regexp
 * @returns {Array}
 */
String.prototype.match = function(regexp) {};

/**
 * @since ECMAScript6
 * @syntax str.repeat(count)
 * @param {Number} count
 * @returns {String}
 */
String.prototype.repeat = function(count) {};

/**
 * @syntax str.toLowerCase()
 * @returns {String}
 */
String.prototype.toLowerCase = function() {};

/**
 * @syntax str.toUpperCase()
 * @returns {String}
 */
String.prototype.toUpperCase = function() {};

/**
 * @since ECMAScript6
 * @syntax str.anchor(name)
 * @param {String} name
 * @returns {String}
 */
String.prototype.anchor = function(name) {};

/**
 * @syntax str.concat(string2, string3[, ..., stringN])
 * @param {String} string2...stringN
 * @returns {String}
 */
String.prototype.concat = function(string2, string3) {};

/**
 * @syntax str.indexOf(searchValue[, fromIndex])
 * @param {String} searchValue
 * @param {Number} fromIndex
 * @returns {Number}
 */
String.prototype.indexOf = function(searchValue) {};

/**
 * @syntax str.charAt(index)
 * @param {Number} index
 * @returns {String}
 */
String.prototype.charAt = function(index) {};

/**
 * @since ECMAScript6
 * @syntax str.normalize([form])
 * @param {String} form
 * @returns {String}
 */
String.prototype.normalize = function() {};

/**
 * @since ECMAScript7
 * @syntax str.padEnd(maxLength[, fillString])
 * @param {Number} maxLength
 * @param {String} fillString
 * @returns {String}
 */
String.prototype.padEnd = function(maxLength) {};

/**
 * @since ECMAScript7
 * @syntax str.padStart(maxLength[, fillString])
 * @param {Number} maxLength
 * @param {String} fillString
 * @returns {String}
 */
String.prototype.padStart = function(maxLength) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.big()
 * @returns {String}
 */
String.prototype.big = function() {};

/**
 * @since ECMAScript6
 * @syntax str.startsWith(searchString[, position])
 * @param {String} searchString
 * @param {String} position
 * @returns {Boolean}
 */
String.prototype.startsWith = function(searchString) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.sup()
 * @returns {String}
 */
String.prototype.sup = function() {};

/**
 * @syntax str.search(regexp)
 * @param {RegExp} regexp
 * @returns {Number}
 */
String.prototype.search = function(regexp) {};

/**
 * @syntax str.toString()
 * @returns {String}
 */
String.prototype.toString = function() {};

/**
 * @syntax str.replace(regexp|substr, newSubStr|function)
 * @param {Object} regexp(pattern)
 * @param {String} substr(pattern)
 * @param {Number} newSubStr(replacement)
 * @param {String} function(replacement)
 * @returns {String}
 */
String.prototype.replace = function(regexp,  newSubStr) {};

/**
 * @syntax str.lastIndexOf(searchValue[, fromIndex])
 * @param {String} searchValue
 * @param {Number} fromIndex
 * @returns {Number}
 */
String.prototype.lastIndexOf = function(searchValue) {};

/**
 * @since ECMAScript6
 * @syntax str.endsWith(searchString[, position])
 * @param {String} searchString
 * @param {String} position
 * @returns {Boolean}
 */
String.prototype.endsWith = function(searchString) {};

/**
 * @syntax str.valueOf()
 * @returns {String}
 */
String.prototype.valueOf = function() {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.strike()
 * @returns {String}
 */
String.prototype.strike = function() {};

/**
 * @syntax str.slice(beginSlice[, endSlice])
 * @param {Number} beginSlice
 * @param {Number} endSlice
 * @returns {String}
 */
String.prototype.slice = function(beginSlice) {};

/**
 * @syntax str.toLocaleLowerCase()
 * @returns {String}
 */
String.prototype.toLocaleLowerCase = function() {};

/**
 * @syntax str.charCodeAt(index)
 * @param {Number} index
 * @returns {Number}
 */
String.prototype.charCodeAt = function(index) {};

/**
 * @since ECMAScript6
 * @syntax String.raw(callSite, ...substitutions) String.raw`templateString`
 * @param {Object} callSite
 * @param {String} ...substitutions
 * @param {String} templateString
 * @returns {String}
 * @static
 */
String.raw = function(callSite) {};

/**
 * @syntax str.split([separator[, limit]])
 * @param {String} separator
 * @param {Number} limit
 * @returns {Array}
 */
String.prototype.split = function() {};

/**
 * @syntax referenceStr.localeCompare(compareString[, locales[, options]])
 * @param {String} compareString
 * @returns {Number}
 */
String.prototype.localeCompare = function(compareString) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.fontcolor(color)
 * @param {String} color
 * @returns {String}
 */
String.prototype.fontcolor = function(color) {};

/**
 * @since ECMAScript6
 * @deprecated
 * @syntax str.italics()
 * @returns {String}
 */
String.prototype.italics = function() {};

/**
 * Represents the String prototype object.
 * @syntax String.prototype
 * @static
 */
String.prototype;

