/**
 * The CSSStyleRule interface represents a single rule set in a CSS style sheet.
 */
var CSSStyleRule = {
}
/**
 * The declaration-block of this rule set.
 * @syntax cSSStyleRule.style
 * @returns {CSSStyleDeclaration} 
 */
CSSStyleRule.prototype.style = new CSSStyleDeclaration();

/**
 * The textual representation of the selector for the rule set. The implementation may have stripped out insignificant whitespace while parsing the selector. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified CSS string value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this rule is readonly.
 * @syntax cSSStyleRule.selectorText
 * @returns {String} 
 */
CSSStyleRule.prototype.selectorText = new String();

/**
 * Represents the CSSStyleRule prototype object.
 * @syntax CSSStyleRule.prototype
 * @static
 */
CSSStyleRule.prototype;

