/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(vec3(-0.03, -0.85, -0.94), vec3(-0.03, -0.85, -0.94)) => 1.607
 * dot(vec3(-0.03, -0.85, -0.94), vec3(1.67, 0.66, 1.87)) => -2.3689
 * dot(vec3(1.67, 0.66, 1.87), vec3(-0.03, -0.85, -0.94)) => -2.3689
 * dot(vec3(1.67, 0.66, 1.87), vec3(1.67, 0.66, 1.87)) => 6.7214
 */
#version 150

void main()
{
  float[distance(dot(vec3(-0.03, -0.85, -0.94), vec3(-0.03, -0.85, -0.94)), 1.607) <= 1.607e-05 ? 1 : -1] array0;
  float[distance(dot(vec3(-0.03, -0.85, -0.94), vec3(1.67, 0.66, 1.87)), -2.3689) <= 2.3689001e-05 ? 1 : -1] array1;
  float[distance(dot(vec3(1.67, 0.66, 1.87), vec3(-0.03, -0.85, -0.94)), -2.3689) <= 2.3689001e-05 ? 1 : -1] array2;
  float[distance(dot(vec3(1.67, 0.66, 1.87), vec3(1.67, 0.66, 1.87)), 6.7214) <= 6.7214e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
