/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u ^ (~ uvec2(38u, 35u))) => uvec2(4294967257u, 4294967260u)
 * (0u ^ (~ uvec2(64u, 9u))) => uvec2(4294967231u, 4294967286u)
 * (6u ^ (~ uvec2(38u, 35u))) => uvec2(4294967263u, 4294967258u)
 * (6u ^ (~ uvec2(64u, 9u))) => uvec2(4294967225u, 4294967280u)
 * (12u ^ (~ uvec2(38u, 35u))) => uvec2(4294967253u, 4294967248u)
 * (12u ^ (~ uvec2(64u, 9u))) => uvec2(4294967219u, 4294967290u)
 * (32u ^ (~ uvec2(38u, 35u))) => uvec2(4294967289u, 4294967292u)
 * (32u ^ (~ uvec2(64u, 9u))) => uvec2(4294967199u, 4294967254u)
 * (74u ^ (~ uvec2(38u, 35u))) => uvec2(4294967187u, 4294967190u)
 * (74u ^ (~ uvec2(64u, 9u))) => uvec2(4294967285u, 4294967228u)
 */
#version 150

void main()
{
  float[all(equal((0u ^ (~ uvec2(38u, 35u))), uvec2(4294967257u, 4294967260u))) ? 1 : -1] array0;
  float[all(equal((0u ^ (~ uvec2(64u, 9u))), uvec2(4294967231u, 4294967286u))) ? 1 : -1] array1;
  float[all(equal((6u ^ (~ uvec2(38u, 35u))), uvec2(4294967263u, 4294967258u))) ? 1 : -1] array2;
  float[all(equal((6u ^ (~ uvec2(64u, 9u))), uvec2(4294967225u, 4294967280u))) ? 1 : -1] array3;
  float[all(equal((12u ^ (~ uvec2(38u, 35u))), uvec2(4294967253u, 4294967248u))) ? 1 : -1] array4;
  float[all(equal((12u ^ (~ uvec2(64u, 9u))), uvec2(4294967219u, 4294967290u))) ? 1 : -1] array5;
  float[all(equal((32u ^ (~ uvec2(38u, 35u))), uvec2(4294967289u, 4294967292u))) ? 1 : -1] array6;
  float[all(equal((32u ^ (~ uvec2(64u, 9u))), uvec2(4294967199u, 4294967254u))) ? 1 : -1] array7;
  float[all(equal((74u ^ (~ uvec2(38u, 35u))), uvec2(4294967187u, 4294967190u))) ? 1 : -1] array8;
  float[all(equal((74u ^ (~ uvec2(64u, 9u))), uvec2(4294967285u, 4294967228u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
