/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AliasNamespace
extends AbstractNamespace {
    protected final SqlCall call;

    protected AliasNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
        assert (call.getOperator() == SqlStdOperatorTable.AS);
        assert (call.operandCount() >= 2);
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        List<SqlNode> operands = this.call.getOperandList();
        SqlValidatorNamespace childNs = this.validator.getNamespaceOrThrow(operands.get(0));
        return childNs.supportsModality(modality);
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataType aliasedType;
        List<SqlNode> operands = this.call.getOperandList();
        SqlValidatorNamespace childNs = this.validator.getNamespaceOrThrow(operands.get(0));
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        if (operands.size() == 2) {
            aliasedType = rowType.getFieldCount() == 1 ? this.validator.getTypeFactory().builder().kind(rowType.getStructKind()).add(((SqlIdentifier)operands.get(1)).getSimple(), rowType.getFieldList().get(0).getType()).build() : rowType;
        } else {
            List<SqlNode> columnNames = Util.skip(operands, 2);
            List<String> nameList = SqlIdentifier.simpleNames(columnNames);
            int i = Util.firstDuplicate(nameList);
            if (i >= 0) {
                SqlIdentifier id = (SqlIdentifier)columnNames.get(i);
                throw this.validator.newValidationError(id, Static.RESOURCE.aliasListDuplicate(id.getSimple()));
            }
            if (columnNames.size() != rowType.getFieldCount()) {
                SqlNode node = operands.size() == 3 ? operands.get(2) : new SqlNodeList(columnNames, SqlParserPos.sum(columnNames));
                throw this.validator.newValidationError(node, Static.RESOURCE.aliasListDegree(rowType.getFieldCount(), AliasNamespace.getString(rowType), columnNames.size()));
            }
            aliasedType = ((RelDataTypeFactory.FieldInfoBuilder)this.validator.getTypeFactory().builder().addAll(Util.transform(rowType.getFieldList(), f -> Pair.of(nameList.get(f.getIndex()), f.getType())))).kind(rowType.getStructKind()).build();
        }
        if (rowType instanceof RelDataTypeFactoryImpl.JavaType) {
            return aliasedType;
        }
        return this.validator.getTypeFactory().createTypeWithNullability(aliasedType, rowType.isNullable());
    }

    private static String getString(RelDataType rowType) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (field.getIndex() > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(field.getName());
            buf.append("'");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.call;
    }

    @Override
    public String translate(String name) {
        RelDataType underlyingRowType = this.validator.getValidatedNodeType((SqlNode)this.call.operand(0));
        int i = 0;
        for (RelDataTypeField field : this.getRowType().getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

