'\"
'\" Generated from file 'asn\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\" Copyright (c) 2004 Jochen Loewer <loewerj@web\&.de>
'\" Copyright (c) 2004-2011 Michael Schlenker <mic42@users\&.sourceforge\&.net>
'\"
.TH "asn" n 0\&.8 tcllib "ASN\&.1 processing"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
asn \- ASN\&.1 BER encoder/decoder
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBasn  ?0\&.8\&.4?\fR
.sp
\fB::asn::asnSequence\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnSequenceFromList\fR \fIelist\fR
.sp
\fB::asn::asnSet\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnSetFromList\fR \fIelist\fR
.sp
\fB::asn::asnApplicationConstr\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnApplication\fR \fIappNumber\fR \fIdata\fR
.sp
\fB::asn::asnChoice\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnChoiceConstr\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnInteger\fR \fInumber\fR
.sp
\fB::asn::asnEnumeration\fR \fInumber\fR
.sp
\fB::asn::asnBoolean\fR \fIbool\fR
.sp
\fB::asn::asnContext\fR \fIcontext\fR \fIdata\fR
.sp
\fB::asn::asnContextConstr\fR \fIcontext\fR \fIevalue\fR\&.\&.\&.
.sp
\fB::asn::asnObjectIdentifier\fR \fIidlist\fR
.sp
\fB::asn::asnUTCTime\fR \fIutcstring\fR
.sp
\fB::asn::asnNull\fR
.sp
\fB::asn::asnBitString\fR \fIstring\fR
.sp
\fB::asn::asnOctetString\fR \fIstring\fR
.sp
\fB::asn::asnNumericString\fR \fIstring\fR
.sp
\fB::asn::asnPrintableString\fR \fIstring\fR
.sp
\fB::asn::asnIA5String\fR \fIstring\fR
.sp
\fB::asn::asnBMPString\fR \fIstring\fR
.sp
\fB::asn::asnUTF8String\fR \fIstring\fR
.sp
\fB::asn::asnString\fR \fIstring\fR
.sp
\fB::asn::defaultStringType\fR ?\fItype\fR?
.sp
\fB::asn::asnPeekByte\fR \fIdata_var\fR \fIbyte_var\fR
.sp
\fB::asn::asnGetLength\fR \fIdata_var\fR \fIlength_var\fR
.sp
\fB::asn::asnGetResponse\fR \fIchan\fR \fIdata_var\fR
.sp
\fB::asn::asnGetInteger\fR \fIdata_var\fR \fIint_var\fR
.sp
\fB::asn::asnGetEnumeration\fR \fIdata_var\fR \fIenum_var\fR
.sp
\fB::asn::asnGetOctetString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetString\fR \fIdata_var\fR \fIstring_var\fR ?\fItype_var\fR?
.sp
\fB::asn::asnGetNumericString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetPrintableString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetIA5String\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetBMPString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetUTF8String\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetUTCTime\fR \fIdata_var\fR \fIutc_var\fR
.sp
\fB::asn::asnGetBitString\fR \fIdata_var\fR \fIbits_var\fR
.sp
\fB::asn::asnGetObjectIdentifier\fR \fIdata_var\fR \fIoid_var\fR
.sp
\fB::asn::asnGetBoolean\fR \fIdata_var\fR \fIbool_var\fR
.sp
\fB::asn::asnGetNull\fR \fIdata_var\fR
.sp
\fB::asn::asnGetSequence\fR \fIdata_var\fR \fIsequence_var\fR
.sp
\fB::asn::asnGetSet\fR \fIdata_var\fR \fIset_var\fR
.sp
\fB::asn::asnGetApplication\fR \fIdata_var\fR \fIappNumber_var\fR ?\fIcontent_var\fR? ?\fIencodingType_var\fR?
.sp
\fB::asn::asnGetContext\fR \fIdata_var\fR \fIcontextNumber_var\fR ?\fIcontent_var\fR? ?\fIencodingType_var\fR?
.sp
\fB::asn::asnPeekTag\fR \fIdata_var\fR \fItag_var\fR \fItagtype_var\fR \fIconstr_var\fR
.sp
\fB::asn::asnTag\fR \fItagnumber\fR ?\fIclass\fR? ?\fItagstyle\fR?
.sp
\fB::asn::asnRetag\fR \fIdata_var\fR \fInewTag\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBasn\fR package provides \fIpartial\fR de- and encoder
commands for BER encoded ASN\&.1 data\&. It can also be used for
decoding DER, which is a restricted subset of BER\&.
.PP
ASN\&.1 is a standard \fIAbstract Syntax Notation\fR, and BER are its
\fIBasic Encoding Rules\fR\&.
.PP
See \fIhttp://asn1\&.elibel\&.tm\&.fr/en/standards/index\&.htm\fR for more
information about the standard\&.
.PP
Also see \fIhttp://luca\&.ntop\&.org/Teaching/Appunti/asn1\&.html\fR for
\fIA Layman's Guide to a Subset of ASN\&.1, BER, and DER\fR, an RSA
Laboratories Technical Note by Burton S\&. Kaliski Jr\&. (Revised November
1, 1993)\&. A text version of this note is part of the module sources
and should be read by any implementor\&.
.SH "PUBLIC API"
.SS ENCODER
.TP
\fB::asn::asnSequence\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values, packs them into an ASN sequence and
returns its encoded binary form\&.
.TP
\fB::asn::asnSequenceFromList\fR \fIelist\fR
Takes a list of encoded values, packs them into an ASN sequence and
returns its encoded binary form\&.
.TP
\fB::asn::asnSet\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values, packs them into an ASN set and
returns its encoded binary form\&.
.TP
\fB::asn::asnSetFromList\fR \fIelist\fR
Takes a list of encoded values, packs them into an ASN set and
returns its encoded binary form\&.
.TP
\fB::asn::asnApplicationConstr\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values, packs them into an ASN application
construct and returns its encoded binary form\&.
.TP
\fB::asn::asnApplication\fR \fIappNumber\fR \fIdata\fR
Takes a single encoded value \fIdata\fR, packs it into an ASN
application construct and returns its encoded binary form\&.
.TP
\fB::asn::asnChoice\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values, packs them into an ASN choice
construct and returns its encoded binary form\&.
.TP
\fB::asn::asnChoiceConstr\fR \fIappNumber\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values, packs them into an ASN choice
construct and returns its encoded binary form\&.
.TP
\fB::asn::asnInteger\fR \fInumber\fR
Returns the encoded form of the specified integer
\fInumber\fR\&.
.TP
\fB::asn::asnEnumeration\fR \fInumber\fR
Returns the encoded form of the specified enumeration id
\fInumber\fR\&.
.TP
\fB::asn::asnBoolean\fR \fIbool\fR
Returns the encoded form of the specified boolean value
\fIbool\fR\&.
.TP
\fB::asn::asnContext\fR \fIcontext\fR \fIdata\fR
Takes an encoded value and packs it into a constructed value with
application tag, the \fIcontext\fR number\&.
.TP
\fB::asn::asnContextConstr\fR \fIcontext\fR \fIevalue\fR\&.\&.\&.
Takes zero or more encoded values and packs them into a constructed
value with application tag, the \fIcontext\fR number\&.
.TP
\fB::asn::asnObjectIdentifier\fR \fIidlist\fR
Takes a list of at least 2 integers describing an object identifier
(OID) value, and returns the encoded value\&.
.TP
\fB::asn::asnUTCTime\fR \fIutcstring\fR
Returns the encoded form of the specified UTC time string\&.
.TP
\fB::asn::asnNull\fR
Returns the NULL encoding\&.
.TP
\fB::asn::asnBitString\fR \fIstring\fR
Returns the encoded form of the specified \fIstring\fR\&.
.TP
\fB::asn::asnOctetString\fR \fIstring\fR
Returns the encoded form of the specified \fIstring\fR\&.
.TP
\fB::asn::asnNumericString\fR \fIstring\fR
Returns the \fIstring\fR encoded as ASN\&.1 NumericString\&. Raises an
error if the \fIstring\fR contains characters other than decimal
numbers and space\&.
.TP
\fB::asn::asnPrintableString\fR \fIstring\fR
Returns the \fIstring\fR encoding as ASN\&.1 PrintableString\&. Raises an
error if the \fIstring\fR contains characters which are not allowed by
the Printable String datatype\&. The allowed characters are A-Z, a-z,
0-9, space, apostrophe, colon, parentheses, plus, minus, comma,
period, forward slash, question mark, and the equals sign\&.
.TP
\fB::asn::asnIA5String\fR \fIstring\fR
Returns the \fIstring\fR encoded as ASN\&.1 IA5String\&. Raises an error
if the \fIstring\fR contains any characters outside of the US-ASCII
range\&.
.TP
\fB::asn::asnBMPString\fR \fIstring\fR
Returns the \fIstring\fR encoded as ASN\&.1 Basic Multilingual Plane
string (Which is essentialy big-endian UCS2)\&.
.TP
\fB::asn::asnUTF8String\fR \fIstring\fR
Returns the \fIstring\fR encoded as UTF8 String\&. Note that some legacy
applications such as Windows CryptoAPI do not like UTF8 strings\&. Use
BMPStrings if you are not sure\&.
.TP
\fB::asn::asnString\fR \fIstring\fR
Returns an encoded form of \fIstring\fR, choosing the most restricted
ASN\&.1 string type possible\&. If the string contains non-ASCII
characters, then there is more than one string type which can be
used\&. See \fB::asn::defaultStringType\fR\&.
.TP
\fB::asn::defaultStringType\fR ?\fItype\fR?
Selects the string type to use for the encoding of non-ASCII
strings\&. Returns current default when called without argument\&. If the
argument \fItype\fR is supplied, it should be either \fBUTF8\fR or
\fBBMP\fR to choose UTF8String or BMPString respectively\&.
.PP
.PP
.SS DECODER
General notes:
.IP [1]
Nearly all decoder commands take two arguments\&. These arguments are variable
names, except for \fB::asn::asnGetResponse\fR\&. The first variable
contains the encoded ASN value to decode at the beginning, and more,
and the second variable is where the value is stored to\&. The remainder
of the input after the decoded value is stored back into the
datavariable\&.
.IP [2]
After extraction the data variable is always modified first, before by
writing the extracted value to its variable\&. This means that if both
arguments refer to the same variable, it will always contain the
extracted value after the call, and not the remainder of the input\&.
.PP
.PP
.TP
\fB::asn::asnPeekByte\fR \fIdata_var\fR \fIbyte_var\fR
Retrieve the first byte of the data, without modifing \fIdata_var\fR\&.
This can be used to check for implicit tags\&.
.TP
\fB::asn::asnGetLength\fR \fIdata_var\fR \fIlength_var\fR
Decode the length information for a block of BER data\&. The tag has already
to be removed from the data\&.
.TP
\fB::asn::asnGetResponse\fR \fIchan\fR \fIdata_var\fR
Reads an encoded ASN \fIsequence\fR from the channel \fIchan\fR and
stores it into the variable named by \fIdata_var\fR\&.
.TP
\fB::asn::asnGetInteger\fR \fIdata_var\fR \fIint_var\fR
Assumes that an encoded integer value is at the front of the data
stored in the variable named \fIdata_var\fR, extracts and stores it
into the variable named by \fIint_var\fR\&. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands\&.
.TP
\fB::asn::asnGetEnumeration\fR \fIdata_var\fR \fIenum_var\fR
Assumes that an enumeration id is at the front of the data stored in
the variable named \fIdata_var\fR, and stores it into the variable
named by \fIenum_var\fR\&. Additionally removes all bytes associated
with the value from the data for further processing by the following
decoder commands\&.
.TP
\fB::asn::asnGetOctetString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a string is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIstring_var\fR\&. Additionally removes all bytes associated with
the value from the data for further processing by the following
decoder commands\&.
.TP
\fB::asn::asnGetString\fR \fIdata_var\fR \fIstring_var\fR ?\fItype_var\fR?
Decodes a user-readable string\&. This is a convenience function which
is able to automatically distinguish all supported ASN\&.1 string types
and convert the input value appropriately\&.
See \fB::asn::asnGetPrintableString\fR, \fB::asnGetIA5String\fR, etc\&.
below for the type-specific conversion commands\&.
.sp
If the optional third argument \fItype_var\fR is supplied, then the
type of the incoming string is stored in the variable named by it\&.
.sp
The function throws the error
"Invalid command name asnGetSome\fBUnsupportedString\fR" if the
unsupported string type \fBUnsupported\fR is encountered\&. You can
create the appropriate function
"asn::asnGetSome\fBUnsupportedString\fR" in your application if
neccessary\&.
.TP
\fB::asn::asnGetNumericString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a numeric string value is at the front of the data stored
in the variable named \fIdata_var\fR, and stores it into the variable
named by \fIstring_var\fR\&. Additionally removes all bytes associated
with the value from the data for further processing by the following
decoder commands\&.
.TP
\fB::asn::asnGetPrintableString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a printable string value is at the front of the data
stored in the variable named \fIdata_var\fR, and stores it into the
variable named by \fIstring_var\fR\&. Additionally removes all bytes
associated with the value from the data for further processing by the
following decoder commands\&.
.TP
\fB::asn::asnGetIA5String\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a IA5 (ASCII) string value is at the front of the data
stored in the variable named \fIdata_var\fR, and stores it into the
variable named by \fIstring_var\fR\&. Additionally removes all bytes
associated with the value from the data for further processing by the
following decoder commands\&.
.TP
\fB::asn::asnGetBMPString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a BMP (two-byte unicode) string value is at the front of
the data stored in the variable named \fIdata_var\fR, and stores it
into the variable named by \fIstring_var\fR, converting it into a
proper Tcl string\&. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.TP
\fB::asn::asnGetUTF8String\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a UTF8 string value is at the front of the data stored in
the variable named \fIdata_var\fR, and stores it into the variable
named by \fIstring_var\fR, converting it into a proper Tcl string\&.
Additionally removes all bytes associated with the value from the data
for further processing by the following decoder commands\&.
.TP
\fB::asn::asnGetUTCTime\fR \fIdata_var\fR \fIutc_var\fR
Assumes that a UTC time value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIutc_var\fR\&. The UTC time value is stored as a string, which has to
be decoded with the usual clock scan commands\&.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.TP
\fB::asn::asnGetBitString\fR \fIdata_var\fR \fIbits_var\fR
Assumes that a bit string value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIbits_var\fR as a string containing only 0 and 1\&.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.TP
\fB::asn::asnGetObjectIdentifier\fR \fIdata_var\fR \fIoid_var\fR
Assumes that a object identifier (OID) value is at the front of the data
stored in the variable named \fIdata_var\fR, and stores it into the variable
named by \fIoid_var\fR as a list of integers\&.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.TP
\fB::asn::asnGetBoolean\fR \fIdata_var\fR \fIbool_var\fR
Assumes that a boolean value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIbool_var\fR\&. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.TP
\fB::asn::asnGetNull\fR \fIdata_var\fR
Assumes that a NULL value is at the front of the data stored in the
variable named \fIdata_var\fR and removes the bytes used to encode it
from the data\&.
.TP
\fB::asn::asnGetSequence\fR \fIdata_var\fR \fIsequence_var\fR
Assumes that an ASN sequence is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIsequence_var\fR\&. Additionally removes all bytes associated with
the value from the data for further processing by the following
decoder commands\&.
.sp
The data in \fIsequence_var\fR is encoded binary and has to be
further decoded according to the definition of the sequence, using the
decoder commands here\&.
.TP
\fB::asn::asnGetSet\fR \fIdata_var\fR \fIset_var\fR
Assumes that an ASN set is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIset_var\fR\&. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands\&.
.sp
The data in \fIset_var\fR is encoded binary and has to be further
decoded according to the definition of the set, using the decoder
commands here\&.
.TP
\fB::asn::asnGetApplication\fR \fIdata_var\fR \fIappNumber_var\fR ?\fIcontent_var\fR? ?\fIencodingType_var\fR?
Assumes that an ASN application construct is at the front of the data
stored in the variable named \fIdata_var\fR, and stores its id into
the variable named by \fIappNumber_var\fR\&. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands\&.
If a \fIcontent_var\fR is specified, then the command places all data
associated with it into the named variable, in the binary form which
can be processed using the decoder commands of this package\&.
If a \fIencodingType_var\fR is specified, then that var is set to 1 if
the encoding is constructed and 0 if it is primitive\&.
.sp
Otherwise it is the responsibility of the caller to decode the
remainder of the application construct based on the id retrieved by
this command, using the decoder commands of this package\&.
.TP
\fB::asn::asnGetContext\fR \fIdata_var\fR \fIcontextNumber_var\fR ?\fIcontent_var\fR? ?\fIencodingType_var\fR?
Assumes that an ASN context tag construct is at the front of the data
stored in the variable named \fIdata_var\fR, and stores its id into
the variable named by \fIcontextNumber_var\fR\&. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands\&.
If a \fIcontent_var\fR is specified, then the command places all data
associated with it into the named variable, in the binary form which
can be processed using the decoder commands of this package\&.
If a \fIencodingType_var\fR is specified, then that var is set to 1 if
the encoding is constructed and 0 if it is primitive\&.
.sp
Otherwise it is the responsibility of the caller to decode the
remainder of the construct based on the id retrieved by this command,
using the decoder commands of this package\&.
.PP
.PP
.SS "HANDLING TAGS"
Working with ASN\&.1 you often need to decode tagged values, which use a tag thats different
from the universal tag for a type\&. In those cases you have to replace the tag with the universal tag
used for the type, to decode the value\&.
To decode a tagged value use the \fB::asn::asnRetag\fR to change the tag to the appropriate type
to use one of the decoders for primitive values\&.
To help with this the module contains three functions:
.TP
\fB::asn::asnPeekTag\fR \fIdata_var\fR \fItag_var\fR \fItagtype_var\fR \fIconstr_var\fR
The \fB::asn::asnPeekTag\fR command can be used to take a peek at the data and decode the tag value, without
removing it from the data\&. The \fItag_var\fR gets set to the tag number, while the \fItagtype_var\fR gets set
to the class of the tag\&. (Either UNIVERSAL, CONTEXT, APPLICATION or PRIVATE)\&. The \fIconstr_var\fR is set to 1 if the
tag is for a constructed value, and to 0 for not constructed\&. It returns the length of the tag\&.
.TP
\fB::asn::asnTag\fR \fItagnumber\fR ?\fIclass\fR? ?\fItagstyle\fR?
The \fB::asn::asnTag\fR can be used to create a tag value\&. The \fItagnumber\fR gives the number of the tag, while
the \fIclass\fR gives one of the classes (UNIVERSAL,CONTEXT,APPLICATION or PRIVATE)\&. The class may be abbreviated to just the first letter (U,C,A,P),
default is UNIVERSAL\&.
The \fItagstyle\fR is either C for Constructed encoding, or P for primitve encoding\&. It defaults to P\&. You can also use 1 instead of C and
0 instead of P for direct use of the values returned by \fB::asn::asnPeekTag\fR\&.
.TP
\fB::asn::asnRetag\fR \fIdata_var\fR \fInewTag\fR
Replaces the tag in front of the data in \fIdata_var\fR with \fInewTag\fR\&. The new Tag can be created using the \fB::asn::asnTag\fR command\&.
.PP
.SH EXAMPLES
Examples for the usage of this package can be found in the
implementation of package \fBldap\fR\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIasn\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
asn, ber, cer, der, internet, protocol, x\&.208, x\&.209
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
Copyright (c) 2004 Jochen Loewer <loewerj@web\&.de>
Copyright (c) 2004-2011 Michael Schlenker <mic42@users\&.sourceforge\&.net>

.fi