/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GridGraphLayout<N, E>
extends GraphLayout<N, E> {
    private boolean checker = false;
    private int horizontalGap = 64;
    private int verticalGap = 64;

    public GridGraphLayout<N, E> setChecker(boolean bl) {
        this.checker = bl;
        return this;
    }

    public GridGraphLayout<N, E> setGaps(int n, int n2) {
        this.horizontalGap = n;
        this.verticalGap = n2;
        return this;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> universalGraph) {
        int n;
        Cloneable cloneable;
        Object object;
        Widget widget;
        Object object2;
        Object object3;
        Object object42;
        Cloneable cloneable2;
        Object object52;
        Collection<N> collection = universalGraph.getNodes();
        HashSet<N> hashSet = new HashSet<N>(collection);
        final HashMap<Object, Cloneable> hashMap = new HashMap<Object, Cloneable>();
        for (Object object52 : hashSet) {
            cloneable2 = new HashSet();
            for (Object object42 : universalGraph.findNodeEdges(object52, true, false)) {
                object3 = universalGraph.getEdgeTarget(object42);
                if (object3 == null) continue;
                ((HashSet)cloneable2).add(object3);
            }
            object2 = universalGraph.findNodeEdges(object52, false, true).iterator();
            while (object2.hasNext()) {
                object42 = object2.next();
                object3 = universalGraph.getEdgeSource(object42);
                if (object3 == null) continue;
                ((HashSet)cloneable2).add(object3);
            }
            hashMap.put(object52, cloneable2);
        }
        LinkedList linkedList = new LinkedList();
        object52 = new HashMap();
        cloneable2 = new Rectangle();
        block3: while (true) {
            Object object6 = object2 = linkedList.isEmpty() ? GridGraphLayout.findNodeWithMaxEdges(hashSet, hashMap) : linkedList.poll();
            if (object2 == null) break;
            hashSet.remove(object2);
            object42 = (Point)((HashMap)object52).get(object2);
            if (object42 == null) {
                object42 = this.findCenter((HashMap<N, Point>)object52);
                ((HashMap)object52).put(object2, object42);
                ((Rectangle)cloneable2).add((Point)object42);
            }
            object3 = new Point();
            ArrayList arrayList = new ArrayList((Collection)hashMap.get(object2));
            Collections.sort(arrayList, new Comparator<N>(){

                @Override
                public int compare(N n, N n2) {
                    return ((Collection)hashMap.get(n)).size() - ((Collection)hashMap.get(n2)).size();
                }
            });
            Object object7 = arrayList.iterator();
            while (true) {
                if (!object7.hasNext()) continue block3;
                widget = object7.next();
                if (hashSet.contains(widget)) {
                    linkedList.offer(widget);
                }
                if (((HashMap)object52).containsKey(widget)) continue;
                object = this.resolvePoint((HashMap<N, Point>)object52, (Point)object42, (Point)object3);
                ((HashMap)object52).put(widget, object);
                ((Rectangle)cloneable2).add((Point)object);
            }
            break;
        }
        object2 = universalGraph.getScene();
        object42 = new int[((Rectangle)cloneable2).width + 1];
        object3 = new int[((Rectangle)cloneable2).height + 1];
        for (Object object7 : collection) {
            widget = ((ObjectScene)object2).findWidget(object7);
            if (widget == null || (object = widget.getBounds()) == null) continue;
            cloneable = (Point)((HashMap)object52).get(object7);
            object42[cloneable.x - ((Rectangle)cloneable2).x] = Math.max(object42[cloneable.x - ((Rectangle)cloneable2).x], ((Rectangle)object).width);
            object3[cloneable.y - ((Rectangle)cloneable2).y] = Math.max(object3[cloneable.y - ((Rectangle)cloneable2).y], ((Rectangle)object).height);
        }
        int n2 = this.horizontalGap / 2;
        for (n = 0; n < ((E)object42).length; ++n) {
            E e = object42[n];
            object42[n] = n2;
            n2 += e + this.horizontalGap;
        }
        n2 = this.verticalGap / 2;
        for (n = 0; n < ((N)object3).length; ++n) {
            N n3 = object3[n];
            object3[n] = n2;
            n2 += n3 + this.verticalGap;
        }
        for (N n4 : collection) {
            object = ((ObjectScene)object2).findWidget(n4);
            if (object == null || (cloneable = ((Widget)object).getBounds()) == null) continue;
            Point point = (Point)((HashMap)object52).get(n4);
            this.setResolvedNodeLocation(universalGraph, n4, new Point((int)(object42[point.x - ((Rectangle)cloneable2).x] - ((Rectangle)cloneable).x), (int)object3[point.y - ((Rectangle)cloneable2).y]));
        }
    }

    private <N> Point resolvePoint(HashMap<N, Point> hashMap, Point point, Point point2) {
        Point point3;
        do {
            int n = 8 * point2.y;
            ++point2.x;
            if (point2.x >= n) {
                ++point2.y;
                point2.x -= n;
            }
            point3 = GridGraphLayout.index2point(point2);
            point3.x += point.x;
            point3.y += point.y;
        } while (this.checker && (point3.x + point3.y & 1) != 0 || GridGraphLayout.isOccupied(hashMap, point3));
        return point3;
    }

    private <N> Point findCenter(HashMap<N, Point> hashMap) {
        int n = this.checker ? 2 : 1;
        int n2 = 0;
        Point point;
        while (GridGraphLayout.isOccupied(hashMap, point = new Point(n2, 0))) {
            n2 += n;
        }
        return point;
    }

    private static Point index2point(Point point) {
        int n = point.x;
        int n2 = point.y;
        if (n < n2) {
            return new Point(n2, n);
        }
        if (n < 3 * n2) {
            return new Point(n2 - (n - n2), n2);
        }
        if (n < 5 * n2) {
            return new Point(-n2, n2 - (n - 3 * n2));
        }
        if (n < 7 * n2) {
            return new Point(n - 5 * n2 - n2, -n2);
        }
        if (n < 8 * n2) {
            return new Point(n2, n - 7 * n2 - n2);
        }
        throw new InternalError("Index: " + n);
    }

    private static <N> boolean isOccupied(HashMap<N, Point> hashMap, Point point) {
        for (Point point2 : hashMap.values()) {
            if (point.x != point2.x || point.y != point2.y) continue;
            return true;
        }
        return false;
    }

    private static <N> N findNodeWithMaxEdges(HashSet<N> hashSet, HashMap<N, Collection<N>> hashMap) {
        N n = null;
        int n2 = Integer.MIN_VALUE;
        for (N n3 : hashSet) {
            int n4 = hashMap.get(n3).size();
            if (n4 <= n2) continue;
            n = n3;
            n2 = n4;
        }
        return n;
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> collection) {
        throw new UnsupportedOperationException();
    }
}

